(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1289683,      27445]
NotebookOptionsPosition[   1282509,      27340]
NotebookOutlinePosition[   1282987,      27358]
CellTagsIndexPosition[   1282944,      27355]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<C21_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<BG25_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914972133528996`*^9, 
   3.8914972138838634`*^9}, {3.8914991163760495`*^9, 3.89149911657799*^9}},
 CellLabel->
  "In[894]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C21_30.7138\"\>", ",", "\<\"C21_10.0042\"\>", 
   ",", "\<\"C21_1.504\"\>", ",", "\<\"BG25_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.8914972154035673`*^9, 3.8914975432719035`*^9, 3.891498587225662*^9, 
   3.891499117841081*^9, 3.8914994453271046`*^9, 3.891502106243915*^9, 
   3.8916955627260737`*^9, 3.8926098630306945`*^9, 3.89269676558632*^9, 
   3.90464192625237*^9, 3.9047153884305964`*^9, 3.905852677121832*^9, 
   3.9156931563910866`*^9, 3.9156976392589855`*^9, 3.9175088598551526`*^9, 
   3.917513095923765*^9, 3.9186316346042705`*^9, 3.9186420429878607`*^9, 
   3.9187230929215097`*^9},
 CellLabel->
  "Out[894]=",ExpressionUUID->"8f97bfba-2db1-4946-83f8-0878fab051c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[325]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUlnc81f8Xx+927T0yClFGIaHMz4ciSqkofKWSRFKknQbKSkmStEgkkayy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         "]], 
        LineBox[{{-1.3931625929004259`, -4.724153831427947}, \
{-1.3925541015537621`, -2.8137568098400383`}, {-1.3920904212426208`, \
-5.298317366548036}}], 
        LineBox[{{-1.391838046037591, -5.298317366548036}, \
{-1.391338288426397, -1.7181746543475724`}, {-1.3907309656742075`, \
-3.0662114171459303`}, {-1.3901239517057393`, -2.7545252804661926`}, \
{-1.3895173657767712`, -2.2532572399308655`}, {-1.3889110878104278`, \
-2.499579477411828}, {-1.3883052369189728`, -3.019950377934648}, \
{-1.387699693172116, -2.0568581772542274`}, {-1.3870945755389497`, \
-2.6872484990947734`}, {-1.3864897642354097`, -2.215497489797517}, \
{-1.3858853185074895`, -5.263158408678167}}], 
        LineBox[{{-1.3846776410293211`, -2.6730579116852162`}, \
{-1.3840742893096247`, -2.3567470504004104`}}], 
        LineBox[{{-1.382868795674771, -2.126981653276589}, \
{-1.382266534010283, -2.103425785051137}}], 
        LineBox[{{-1.3810630977476013`, -1.096605482815729}, \
{-1.3804620407940025`, -0.6337943699545862}, {-1.3798612264479944`, \
-4.716652932487689}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xv8blWtdFVhEyvhkZRYp0r1mpZJbZoCiiVNKwVaSS0UIpSQqF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         "]], 
        LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAArYvMPhZi0b9TnJQbejEVwKvltw+8
WNG/Ega1j6uMEsCATbtRxU7RvxBLXZvVYRLAd1ZwdNBE0b/zLCBNo/UTwHIk
qc/cOtG/yz7qDQJ2EsBTRMq26jDRv4pdedLLXRLA/mUEffom0b9io6IuZjoS
wOF6eHoLHdG/kJu3rzsUEsDipGQCHhPRv2Mds7cAyBHA81jTZzIJ0b+Oq6oZ
p48SwCIMNANI/9C//cVhSg7KE8B6mJ4nX/XQv6dsv2I5QRPA1lr3J3jr0L9v
3c5DdJAQwGEC/FyS4dC/t4m6k3CfEcA8RJ4ZrtfQv3DMD7977BHA2oecsMvN
0L+l0IHFyFITwGRtAnvqw9C/l0+z4P2SE8DSp5vLCrrQv30krVkG9xDArcsA
9Syw0L8cGal5cIcSwGshi1BQptC/KMIG6IbpDcBnfOAwdZzQv9V3QubO5hDA
6llyf8WV0L9TnJQbejEVwDP9uqo=
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUmnc8lW0Yx+29T0al3kqlEilRoi6kIRWhQRkNqWjILgmhUFGyyt4ZUZSM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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lf8Xv3svW1RERkhIZd9LZSYkZURJSkmkIqlERltJKErFFylFiSie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         "]], 
        LineBox[CompressedData["
1:eJw9VXs81HkXJol1mfn9ZohqSYnaVjFha9uwNC7pjVxKF0XETrFZUVFEW2Fd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         "]], 
        LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAA1e6lA9s+L9TnJQbejEVwP7vBVJt
afi/KwexYvqTEMBuhDfZlGb4v4G41IfQEhHANWY/9Lxj+L+sTbaTXd0TwCiY
L37lYPi/6QwJmIU6EcDHspObDl74v9Oj2P5p8Q7AF/WKJzhb+L8tWq4rcxIR
wK8hlEZiWPi/VLcPJobEEMBCqtvTjFX4v/kp0z8iGhLAcYTT87dS+L9ro26C
/n4QwCJLtYHjT/i/xdbTyN3dDcDwL+ahD034v/XH368rDhDAgu2sLzxK+L9s
8ilfsAoTwE36YU9pR/i/kG1RpE0FFcBXJ1nclkT4v47sEZ/pjRLAyDje+sRB
+L/tYxK54HkQwKgMUobzPvi/orxxmXVxEcCjvfOiIjz4v/dhaL/Fuw/Aci0x
LFI5+L8dJs2vqwYOwAvWPEaCNvi/yn5AxbdUDsCRk5HMsjP4v9Ah3vg3ShHA
BEhV4+Mw+L8BEwbWHIATwK/AD2YVLvi/NlmOEQlEE8BVUNp4Ryv4vwJeC/x4
sxHAN6xJ93ko+L9O+LCJR7QQwIGgagWtJfi/lFwCVvRFEsBEwd5+4CL4v99e
iR6cixHAulymhxQg+L84SH4K5x0RwKDcb/tIHfi/ggzFBxPVD8DaGS/+fRr4
v7E38w/zPBDAvEqfa7MX+L9MRfarZx0VwGTbp2fpFPi/W0ml1bVpFMCvxRDO
HxL4v7pfJnm8MRHAS515al4P+L9TnJQbejEVwMkMGbo=
         "]], 
        LineBox[{{-1.5037373115477313`, -5.298317366548036}, \
{-1.5030652337220112`, -4.331103292784053}, {-1.5023861452440905`, \
-5.176982644281236}, {-1.5017074507178931`, -5.233671505510157}, \
{-1.501029283356703, -4.187777142744001}, {-1.500351508788963, \
-5.122999128780635}, {-1.49967426004908, -3.9248989701165513`}, \
{-1.4989974029491981`, -4.94981402959598}, {-1.4983210703453254`, \
-3.970192279352568}, {-1.4976451282328034`, -4.509504977213211}, \
{-1.497282419903845, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAApneL4K/y979TnJQbejEVwHlwp7DS
8Pe/oCqk+TMhD8Dl+dtqD+73v0LfRKfBaxDAq/xFjUzr97+wKLB5IB4QwCSv
ajuK6Pe/iztDK8POEMAu5nZRyOX3v6NI1Xw7PxTA/88W4Qbj97/taga8RD0U
wBZq6vtF4Pe/1HrsTwxPE8DKMzF+hd33v3fKU7yUUg7A2R9Si8Xa97/4atrb
9LMPwFwUmf8F2Pe/arFhx2pfFMBr92D+RtX3v0BwMCS87hTAPA0CZIjS979q
SzeSOZEPwGg3y1PKz/e/hxvGkWfoDMCsDyGqDM33v8dW61hyCRXAQHtGik/K
978Vo+tpvI0RwNlgrNCSx/e/Z/RZdD4eEcBksYmg1sT3v6Zq+TaG0w3ACJhb
1hrC97/p9UiKYJYQwO8768mUwPe/U5yUG3oxFcBLt7NN
         "]], 
        LineBox[{{-1.483886653499008, -5.298317366548036}, \
{-1.4835555326370005`, -4.39705131516282}, {-1.4828895602005607`, \
-4.401750227067394}, {-1.482223965382512, -4.374087933670677}, \
{-1.4815588788483816`, -3.9384168175040464`}, {-1.4812637138944458`, \
-5.298317366548036}}], 
        LineBox[{{-1.4803310403373955`, -5.298317366548036}, \
{-1.4802299658562001`, -4.992724114168252}, {-1.480130607317852, \
-5.298317366548036}}], 
        LineBox[{{-1.4790167876091118`, -5.298317366548036}, \
{-1.4789028165302598`, -4.938134008965426}, {-1.478239869107999, \
-5.0622434804610075`}, {-1.4775774261954666`, -3.3915402251370703`}, \
{-1.4769153565646709`, -4.558825204390678}, {-1.4762537901952915`, \
-5.058448137319012}, {-1.4755925960345126`, -4.0385819735202935`}, \
{-1.4749775546448352`, -5.298317366548036}}], 
        LineBox[{{-1.4746371640347773`, -5.298317366548036}, \
{-1.4742715828886581`, -5.1823414383079065`}, {-1.4736117626649108`, \
-4.982317778518238}, {-1.4729523125165611`, -3.931031150665172}, \
{-1.4722933619135883`, -3.726149987245192}, {-1.4716347803258993`, \
-3.82044712941299}, {-1.4709766970544564`, -4.794451356971668}, \
{-1.470569512613433, -5.298317366548036}}], 
        LineBox[{{-1.4699900741939378`, -5.298317366548036}, \
{-1.4696617635223481`, -4.988863228633127}, {-1.4690049122101352`, \
-4.9862082416072315`}, {-1.4683990314453386`, -5.298317366548036}}], 
        LineBox[{{-1.4683340010489607`, -5.298317366548036}, \
{-1.467692567190646, -4.152511638544663}, {-1.467037072268365, \
-4.16446176460503}, {-1.4663819421636302`, -4.217548623597961}, \
{-1.4657273055057047`, -4.7324541834001455`}, {-1.465073032626457, \
-3.4151974642051353`}, {-1.4647478434084786`, -5.298317366548036}}], 
        LineBox[{{-1.4639294832167207`, -5.298317366548036}, \
{-1.4637658340941535`, -4.6625171875140605`}, {-1.4635861917095527`, \
-5.298317366548036}}], 
        LineBox[{{-1.4626413805310627`, -5.298317366548036}, \
{-1.4624603420993125`, -4.655187661493137}, {-1.4622737460920365`, \
-5.298317366548036}}], 
        LineBox[{{-1.4603921544184328`, -5.298317366548036}, \
{-1.4598544599396643`, -3.3016071198731365`}, {-1.459204016997299, \
-4.681394983523469}, {-1.458630550877732, -5.298317366548036}}], 
        LineBox[{{-1.4573737786764684`, -5.298317366548036}, \
{-1.4572553507560915`, -4.6081576337074575`}, {-1.4570061472398073`, \
-5.298317366548036}}], 
        LineBox[{{-1.4562430340056267`, -5.298317366548036}, \
{-1.455958325045854, -4.431771799698098}, {-1.4553104105673174`, \
-3.6884219517704806`}, {-1.4546629794324164`, -3.7875887872405443`}, \
{-1.454015903412415, -4.424856977366221}, {-1.4533693095687956`, \
-4.779929861161433}, {-1.4527230698400555`, -4.210198452513272}, \
{-1.4520773111248584`, -4.726138237648436}, {-1.4514319055284977`, \
-3.809659189144794}, {-1.4507869797872333`, -3.6576939636188914`}}], 
        LineBox[{{-1.4494595020042143`, -5.298317366548036}, \
{-1.4488545674843287`, -4.88190758788891}, {-1.4482113012607243`, \
-4.991634932671452}, {-1.4475683851914845`, -4.404280576219742}, \
{-1.446925945528132, -5.058222512174203}, {-1.4465574513315533`, \
-5.298317366548036}}], 
        LineBox[{{-1.4462147731221693`, -5.298317366548036}, \
{-1.445642239814265, -3.820915009826304}, {-1.4450009727872855`, \
-4.487892130493094}, {-1.4443601798882761`, -3.689620948818113}, \
{-1.4437197342142167`, -4.1859897494254525`}, {-1.4430797615355704`, \
-4.521661853962425}, {-1.4424401351130984`, -3.4512697536520935`}, \
{-1.4418009805577212`, -4.25023259330421}, {-1.4416042175553077`, \
-5.298317366548036}}], 
        LineBox[{{-1.4406928177346845`, -5.298317366548036}, \
{-1.4405238327723882`, -4.450565730070384}, {-1.4401712215799982`, \
-5.298317366548036}}], 
        LineBox[{{-1.4396163915314673`, -5.298317366548036}, \
{-1.4392483140132346`, -4.3610435177695415`}, {-1.438611132817861, \
-4.873463190028933}, {-1.4379744201298463`, -3.9908319487200803`}, \
{-1.437387973634555, -5.298317366548036}}], 
        LineBox[{{-1.4347967358750486`, -4.651005338914097}, \
{-1.434162446467272, -5.125227008565867}}], 
        LineBox[{{-1.4328950108984277`, -4.356067813256831}, \
{-1.4322618637985587`, -4.393001183791281}, {-1.4316291796892966`, \
-4.893982783803193}, {-1.4313152749202462`, -5.298317366548036}}], 
        LineBox[{{-1.429102314139286, -3.7975380561614918`}, \
{-1.428471563070626, -3.5806928834518836`}, {-1.428054099927964, \
-5.298317366548036}}], 
        LineBox[{{-1.427063380108268, -5.298317366548036}, \
{-1.4265817554936695`, -3.3967932259575795`}, {-1.42595265378466, \
-5.001251158093977}, {-1.4253238856188197`, -3.9803091493548735`}, \
{-1.424695574492021, -2.7125261171725916`}, {-1.4240675959930522`, \
-4.565336714721569}, {-1.423440073463934, -3.5096303820731847`}, \
{-1.4230640573350464`, -5.298317366548036}}], 
        LineBox[{{-1.4205899318224064`, -5.298317366548036}, \
{-1.4203081690295074`, -3.935636994726556}, {-1.4196830004606906`, \
-3.9113641821774228`}, {-1.4193428567564446`, -5.298317366548036}}], 
        LineBox[{{-1.4178097133274605`, -4.0750369361463985`}, \
{-1.4171861042786886`, -3.1460246966053}, {-1.4165628224394424`, \
-3.514548710088936}, {-1.4159399902365912`, -3.9104830761884}, \
{-1.4153650725124158`, -5.298317366548036}}], 
        LineBox[{{-1.4143543716746851`, -5.298317366548036}, \
{-1.414073695203434, -3.778047679104936}, {-1.4137264541023669`, \
-5.298317366548036}}], 
        LineBox[{{-1.4096183420134631`, -5.298317366548036}, \
{-1.4091139512378517`, -3.6865429357371795`}, {-1.408759986598989, \
-5.298317366548036}}], 
        LineBox[{{-1.4082412080315263`, -5.298317366548036}, \
{-1.407877849340566, -3.580615504897623}, {-1.40746819022165, \
-5.298317366548036}}], 
        LineBox[{{-1.4070536129033233`, -5.298317366548036}, \
{-1.406643273505007, -3.569438934928174}, {-1.4060265870799868`, \
-3.9277720571367136`}, {-1.4054102199677423`, -4.234246477078686}}], 
        LineBox[{{-1.403562249878592, -5.298317366548036}, \
{-1.4029486648038185`, -3.50232074803919}, {-1.4027706951203969`, \
-5.298317366548036}}], 
        LineBox[{{-1.400840577054237, -5.298317366548036}, \
{-1.4004931540181937`, -3.1121560601199656`}, {-1.3998802474910017`, \
-3.325239376225763}}], 
        LineBox[{{-1.398655499903949, -4.120282342546367}, \
{-1.398043657999477, -3.557972110479627}}], 
        LineBox[{{-1.3931625929004259`, -5.250416840132505}, \
{-1.3925541015537621`, -2.861298478622127}, {-1.3919460401861279`, \
-3.31801981184503}, {-1.391338288426397, -3.493553549565278}}], 
        LineBox[{{-1.3895173657767712`, -3.6246956952954177`}, \
{-1.3889110878104278`, -2.8870540138682053`}}], 
        LineBox[{{-1.4308119554125818`, -5.298317366548036}, \
{-1.4303649487833152`, -4.306568202162434}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xt/e891pJkpE9olBkJBIZaZDxLRSJRImyQnZJWkhUFIpQRBnn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         "]], 
        LineBox[{{-0.274677743164378, -5.298317366548036}, \
{-0.27408705585431015`, -4.969485974757601}, {-0.273598930718067, \
-5.298317366548036}}], 
        LineBox[{{-0.2721308661865039, -5.298317366548036}, \
{-0.27164944546190495`, -5.099040171584874}, {-0.2710409310817236, \
-4.827102489230139}, {-0.27043278676611493`, -5.190183761590067}, \
{-0.27011722996158055`, -5.298317366548036}}], 
        LineBox[{{-0.2692932393090027, -5.298317366548036}, \
{-0.2692176845490116, -5.284095850375458}, {-0.268610647684061, \
-4.678386890519318}, {-0.26800405701359853`, -4.410781081388414}, \
{-0.2673977561952779, -4.831118370141682}, {-0.2671970924629547, \
-5.298317366548036}}], 
        LineBox[{{-0.2656315760385054, -5.298317366548036}, \
{-0.26558113396476035`, -5.285816629941033}, {-0.26497629994481253`, \
-4.720271339889647}, {-0.2643719091696942, -5.228139952607627}, \
{-0.26376780586728016`, -5.03739343249013}, {-0.26316406728534836`, \
-5.08188885025199}, {-0.262560770485036, -5.087528578106296}, \
{-0.26195775997776694`, -4.836499833344438}, {-0.26135511287304525`, \
-4.633771593023157}, {-0.26075290609440566`, -4.760675184375608}, \
{-0.26015098443578805`, -4.607324334564698}, {-0.2595494248689136, \
-4.364465508880019}, {-0.25894830418020226`, -3.4429375320786066`}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcW3c8Vf8bt0cq4mqhpZCVFGU+9KVFEcrILKVsESmpNFFRRlZKIrOEklHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"C21_30.7138\"", "\"C21_10.0042\"", "\"C21_1.504\"", 
       "\"BG25_30.7138\"", "\"BG25_10.0042\"", "\"BG25_1.504\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.891499128090147*^9, 
   3.8914994582819223`*^9, 3.891502117684352*^9, 3.8916955709322443`*^9, 
   3.8926967780465765`*^9, 3.915693165333558*^9, 3.915697644640894*^9},
 CellLabel->
  "Out[326]=",ExpressionUUID->"4a9754cf-0073-4e4a-9031-9cf9dd87eeeb"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914972309806986`*^9, 
   3.891497552617916*^9, 3.8914985996710963`*^9, 3.891499128090147*^9, 
   3.8914994582819223`*^9, 3.891502117684352*^9, 3.8916955709322443`*^9, 
   3.8926967780465765`*^9, 3.915693165333558*^9, 3.9156976463068223`*^9},
 CellLabel->
  "Out[327]=",ExpressionUUID->"d2dad17e-273a-45f0-bd84-c0ea68a3a734"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<C21_30.7138\>\"", ",", "\"\<BG25_30.7138\>\"", ",", "1.1"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C21_10.0042\>\"", ",", "\"\<BG25_10.0042\>\"", ",", "1.1"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{"\"\<C21_1.504\>\"", ",", "\"\<BG25_1.504\>\"", ",", "1.1"}],
          "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.8914972861846867`*^9, 
   3.8914972916516743`*^9}, {3.89149732190543*^9, 3.891497325080738*^9}, {
   3.8914973608592787`*^9, 3.891497387301942*^9}, {3.8914981362303147`*^9, 
   3.8914982511085134`*^9}, {3.891498313222266*^9, 3.8914983218384113`*^9}, {
   3.891498500855095*^9, 3.891498501109005*^9}, {3.8914991502841578`*^9, 
   3.891499209059951*^9}, {3.8914992518783436`*^9, 3.891499304841953*^9}, {
   3.8916956209758377`*^9, 3.8916956265677547`*^9}, {3.8926098713165035`*^9, 
   3.892609877885235*^9}},
 CellLabel->
  "In[896]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUl3dcje8bx88+7T20VIgUlRRanieUhgYiiYZEJGQkSkoLkRUNKSOV6Fva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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnk41P8T38VinXu4Iyl8yVFC6dCuI7qIUEKSlJSUSrpUIkQJXTp0ITqp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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lt8btneRzTuQJJJVZOXWkJBUqERGSkUpESkkaaovKaFEhMgmFOo5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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.015862194265455, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.015862194265455, 
      1.6310721412512184`}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, {3.891499166531208*^9, 3.8914992215412855`*^9}, {
   3.8914992677518625`*^9, 3.8914993140044193`*^9}, 3.8914994756905403`*^9, 
   3.891502133960346*^9, 3.8916956375184717`*^9, 3.8926098839164877`*^9, 
   3.8926968021831236`*^9, 3.9046419327371864`*^9, 3.904715402139823*^9, 
   3.905852686503991*^9, 3.915693180756586*^9, 3.9156976554439983`*^9, 
   3.917509115722267*^9, 3.91751310779109*^9, 3.9186316460994596`*^9, 
   3.918642062082073*^9, 3.918723106077134*^9},
 CellLabel->
  "Out[897]=",ExpressionUUID->"032d90f0-5c0d-4388-90da-f6335e32b555"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\DataSubtracted.pdf\"\>"], \
"Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.89149730439897*^9, 3.891497334536474*^9, {3.891497375192842*^9, 
   3.8914973992304735`*^9}, 3.8914975640870247`*^9, {3.8914981450974956`*^9, 
   3.8914982596763473`*^9}, 3.8914983355783367`*^9, 3.891498513742013*^9, 
   3.891498617526591*^9, {3.891499166531208*^9, 3.8914992215412855`*^9}, {
   3.8914992677518625`*^9, 3.8914993140044193`*^9}, 3.8914994756905403`*^9, 
   3.891502133960346*^9, 3.8916956375184717`*^9, 3.8926098839164877`*^9, 
   3.8926968021831236`*^9, 3.9046419327371864`*^9, 3.904715402139823*^9, 
   3.905852686503991*^9, 3.915693180756586*^9, 3.9156976554439983`*^9, 
   3.917509115722267*^9, 3.91751310779109*^9, 3.9186316460994596`*^9, 
   3.918642062082073*^9, 3.918723107955752*^9},
 CellLabel->
  "Out[898]=",ExpressionUUID->"0e0deca4-7cd4-49a2-b999-8f25fa310b0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.005", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.1", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.3"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", " ", "=", " ", 
     RowBox[{"datamerged", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1", "/", "2.1"}]}], "}"}]}], "}"}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Normalize", " ", "SAXS", " ", "data", " ", "by", " ", "capillary", " ", 
      "thickness", 
      RowBox[{"(", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"unit", " ", "I", 
          RowBox[{"(", "q", ")"}], " ", "in", " ", "mm"}], "-", "1"}], "]"}], 
       ")"}]}], " ", "-", " ", 
     RowBox[{
     "does", " ", "not", " ", "affect", " ", "fit", " ", "results"}]}], 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", " ", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
         "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"I\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\) [a.u.]\>\"", ",", " ", "None"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotDataBinned", ",", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], " ", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "limited", " ", "range"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", " ", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
         "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"I\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"(\
\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\*\
StyleBox[\")\",FontSlant->\"Italic\"]\) [a.u.]\>\"", ",", " ", "None"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinnedLimited.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotDataBinned", ",", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], " ", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "merged", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.8914985305692663`*^9, 3.8914985803250184`*^9}, {3.8914993555058784`*^9, 
   3.8914993557443776`*^9}, {3.8915022018813553`*^9, 
   3.8915022135851674`*^9}, {3.891695705748105*^9, 3.891695705990926*^9}, {
   3.8926099363699303`*^9, 3.89260993736796*^9}, {3.904715486893159*^9, 
   3.904715523271448*^9}, {3.904715823864867*^9, 3.9047158287679005`*^9}, 
   3.9047161144185762`*^9, {3.9047184166638713`*^9, 3.9047184191514378`*^9}, {
   3.905852699437072*^9, 3.9058528208867197`*^9}, {3.9058528780855484`*^9, 
   3.905852922605381*^9}, {3.9059167335953755`*^9, 3.905916754636464*^9}, {
   3.9059170712656317`*^9, 3.905917081315674*^9}, 3.917513167881119*^9, {
   3.9175132322316685`*^9, 3.917513232880139*^9}, {3.918631649872487*^9, 
   3.918631667200945*^9}, {3.91864209421574*^9, 3.918642117961333*^9}, 
   3.9186421970841885`*^9, {3.918723131717885*^9, 3.9187231362091923`*^9}, {
   3.9187231886257*^9, 3.9187232392195415`*^9}, {3.918723274403472*^9, 
   3.918723308384235*^9}, 3.918723357686408*^9, {3.9187233894195557`*^9, 
   3.918723392241726*^9}, {3.918723466047714*^9, 
   3.9187234690062017`*^9}},ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-\
bf843c1633be"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 972, 59, 17132901647633808004, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.891499325347288*^9, 3.891499357139942*^9, 3.8914994806722035`*^9, {
   3.891502202954029*^9, 3.8915022143947096`*^9}, 3.891695659182201*^9, 
   3.8916957065799975`*^9, 3.8926099375774264`*^9, 3.8926968095741673`*^9, 
   3.9047155242840333`*^9, 3.904715829386951*^9, 3.9047161161701565`*^9, 
   3.9047184260874004`*^9, {3.9058527724399986`*^9, 3.9058528213819623`*^9}, {
   3.905852879309307*^9, 3.9058529317223425`*^9}, 3.9059167558957324`*^9, 
   3.905917085354252*^9, 3.91569318331349*^9, 3.9156976575652924`*^9, 
   3.917509123318039*^9, 3.9175131218219967`*^9, 3.91751316834284*^9, 
   3.9175132334099293`*^9, 3.9186316694970427`*^9, 3.9186420694728856`*^9, 
   3.9186421312807603`*^9, 3.9186421978276806`*^9, 3.9187231902692366`*^9, {
   3.9187232864223166`*^9, 3.9187233098518925`*^9}, 3.918723359859537*^9, 
   3.9187233937058134`*^9},
 CellLabel->
  "During evaluation of \
In[972]:=",ExpressionUUID->"2642c561-17f6-4f61-973f-1af5366f9f78"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 973, 60, 17132901647633808004, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.891499325347288*^9, 3.891499357139942*^9, 3.8914994806722035`*^9, {
   3.891502202954029*^9, 3.8915022143947096`*^9}, 3.891695659182201*^9, 
   3.8916957065799975`*^9, 3.8926099375774264`*^9, 3.8926968095741673`*^9, 
   3.9047155242840333`*^9, 3.904715829386951*^9, 3.9047161161701565`*^9, 
   3.9047184260874004`*^9, {3.9058527724399986`*^9, 3.9058528213819623`*^9}, {
   3.905852879309307*^9, 3.9058529317223425`*^9}, 3.9059167558957324`*^9, 
   3.905917085354252*^9, 3.91569318331349*^9, 3.9156976575652924`*^9, 
   3.917509123318039*^9, 3.9175131218219967`*^9, 3.91751316834284*^9, 
   3.9175132334099293`*^9, 3.9186316694970427`*^9, 3.9186420694728856`*^9, 
   3.9186421312807603`*^9, 3.9186421978276806`*^9, 3.9187231902692366`*^9, {
   3.9187232864223166`*^9, 3.9187233098518925`*^9}, 3.918723359859537*^9, 
   3.9187233937399025`*^9},
 CellLabel->
  "During evaluation of \
In[972]:=",ExpressionUUID->"50b63776-d746-4c2d-b399-b0cbe4e8a8ce"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUV3c81t8Xf/ayVyKSyihCqm8hfT5kpkJLUlTSkMykIqvQThsJlZASyiji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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.464132050129068, -5.832637509481894},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.500\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.464132050129068, -0.6940203524770587}, {-5.832637509481894, 
   4.947419005833845}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233939143534`*^9},
 CellLabel->
  "Out[975]=",ExpressionUUID->"e3420dec-a57f-4419-b5da-4ee5d855a247"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVV3k0128TtX/3nfhVirJUllCU0PMhComISkIqFSIikSxRliKUCJVUQkXK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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.454578429743322, -5.7697804237504755`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.454578429743322, -0.920943459371443}, {-5.7697804237504755`,
    4.205481661104468}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.918723394304222*^9},
 CellLabel->
  "Out[976]=",ExpressionUUID->"e50723da-fa16-43c1-8833-8c4cfd32601b"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\DataMerged.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233953053465`*^9},
 CellLabel->
  "Out[977]=",ExpressionUUID->"1e6597b9-6aa3-4496-a74e-98a358d428fa"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.256921585253977, 4.174065704710909}, {-5.256921585253977,
          4.189835529220337}}], 
        LineBox[{{-5.256921585253977, 4.189835529220337}, {-5.256921585253977,
          4.205360522318066}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.2005387488032095`, 
         4.073259742757601}, {-5.2005387488032095`, 4.118587632818974}}], 
        LineBox[{{-5.2005387488032095`, 
         4.118587632818974}, {-5.2005387488032095`, 4.16194969034683}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.147166472619123, 4.060316135610796}, {-5.147166472619123,
          4.089782626107377}}], 
        LineBox[{{-5.147166472619123, 4.089782626107377}, {-5.147166472619123,
          4.118405637625673}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.09649951504208, 4.003106248180086}, {-5.09649951504208, 
         4.01611303271202}}], 
        LineBox[{{-5.09649951504208, 4.01611303271202}, {-5.09649951504208, 
         4.028952810694088}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.048276729473299, 
         3.9389358153149536`}, {-5.048276729473299, 3.955597647650569}}], 
        LineBox[{{-5.048276729473299, 3.955597647650569}, {-5.048276729473299,
          3.9719864070116766`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.002273086667765, 
         3.8914024800279385`}, {-5.002273086667765, 3.903310392808608}}], 
        LineBox[{{-5.002273086667765, 3.903310392808608}, {-5.002273086667765,
          3.915078174238025}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.94768844245325, 3.8139079894512866`}, {-4.94768844245325,
          3.834967815887749}}], 
        LineBox[{{-4.94768844245325, 3.834967815887749}, {-4.94768844245325, 
         3.855593258362314}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.895750762859643, 
         3.7724277923240597`}, {-4.895750762859643, 3.788495548063706}}], 
        LineBox[{{-4.895750762859643, 3.788495548063706}, {-4.895750762859643,
          3.8043092083916625`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.846540574896795, 
         3.6680318725929815`}, {-4.846540574896795, 3.6971948892513216`}}], 
        LineBox[{{-4.846540574896795, 
         3.6971948892513216`}, {-4.846540574896795, 3.7255314688563543`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.7904256789098545`, 
         3.5807972114376416`}, {-4.7904256789098545`, 3.595170940641284}}], 
        LineBox[{{-4.7904256789098545`, 
         3.595170940641284}, {-4.7904256789098545`, 3.6093409899365225`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.745892143749627, 
         3.5305408348680896`}, {-4.745892143749627, 3.53272761870269}}], 
        LineBox[{{-4.745892143749627, 3.53272761870269}, {-4.745892143749627, 
         3.5349096309462915`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.703378855771098, 
         3.4590766095255976`}, {-4.703378855771098, 3.472169423772622}}], 
        LineBox[{{-4.703378855771098, 3.472169423772622}, {-4.703378855771098,
          3.4850930292675857`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.646735106032223, 3.364716685573411}, {-4.646735106032223,
          3.3848178194951477`}}], 
        LineBox[{{-4.646735106032223, 
         3.3848178194951477`}, {-4.646735106032223, 3.4045228469468096`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.592991950938105, 
         3.2732683619492975`}, {-4.592991950938105, 3.295588536605113}}], 
        LineBox[{{-4.592991950938105, 3.295588536605113}, {-4.592991950938105,
          3.3174213786240285`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.5491755160613705`, 
         3.229358754150528}, {-4.5491755160613705`, 3.2394049327590824`}}], 
        LineBox[{{-4.5491755160613705`, 
         3.2394049327590824`}, {-4.5491755160613705`, 3.2493511886722124`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.500425063167319, 
         3.1317298537854725`}, {-4.500425063167319, 3.1460297171712357`}}], 
        LineBox[{{-4.500425063167319, 
         3.1460297171712357`}, {-4.500425063167319, 3.1601279740230326`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.4474126107277066`, 
         3.0428963582873423`}, {-4.4474126107277066`, 3.059686411253172}}], 
        LineBox[{{-4.4474126107277066`, 
         3.059686411253172}, {-4.4474126107277066`, 3.076199207096457}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.397070109545044, 
         2.9463135772451974`}, {-4.397070109545044, 2.959403018876568}}], 
        LineBox[{{-4.397070109545044, 2.959403018876568}, {-4.397070109545044,
          2.972323338356772}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.349141399333698, 2.872285782580809}, {-4.349141399333698,
          2.877656946886363}}], 
        LineBox[{{-4.349141399333698, 2.877656946886363}, {-4.349141399333698,
          2.8829994158447265`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.297879181821557, 
         2.7824187941093794`}, {-4.297879181821557, 2.798573181441161}}], 
        LineBox[{{-4.297879181821557, 2.798573181441161}, {-4.297879181821557,
          2.81447074783161}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.243792424715041, 
         2.6838653228817315`}, {-4.243792424715041, 2.7006713343721764`}}], 
        LineBox[{{-4.243792424715041, 
         2.7006713343721764`}, {-4.243792424715041, 2.71719956578566}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.192482121267007, 
         2.5766830597560872`}, {-4.192482121267007, 2.587555056827199}}], 
        LineBox[{{-4.192482121267007, 2.587555056827199}, {-4.192482121267007,
          2.5983101237033623`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.143677057603073, 
         2.5204816973906157`}, {-4.143677057603073, 2.530559516618549}}], 
        LineBox[{{-4.143677057603073, 2.530559516618549}, {-4.143677057603073,
          2.5405367858878845`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.097143880912867, 2.413056266879144}, {-4.097143880912867,
          2.422233606842421}}], 
        LineBox[{{-4.097143880912867, 2.422233606842421}, {-4.097143880912867,
          2.431327488580964}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.048375288040937, 2.327698031247493}, {-4.048375288040937,
          2.3462696836216175`}}], 
        LineBox[{{-4.048375288040937, 
         2.3462696836216175`}, {-4.048375288040937, 2.3645027090308597`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.997716015667319, 2.226054796373329}, {-3.997716015667319,
          2.242709897757567}}], 
        LineBox[{{-3.997716015667319, 2.242709897757567}, {-3.997716015667319,
          2.259092144950021}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.9456183557485507`, 
         2.131347120083652}, {-3.9456183557485507`, 2.1394536117756386`}}], 
        LineBox[{{-3.9456183557485507`, 
         2.1394536117756386`}, {-3.9456183557485507`, 2.1474949163448325`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.896038528511996, 
         2.0374706798311664`}, {-3.896038528511996, 2.0500144214158937`}}], 
        LineBox[{{-3.896038528511996, 
         2.0500144214158937`}, {-3.896038528511996, 2.0624027648100802`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.8488587655549606`, 
         1.908393140892248}, {-3.8488587655549606`, 1.923147820803117}}], 
        LineBox[{{-3.8488587655549606`, 
         1.923147820803117}, {-3.8488587655549606`, 1.9376879617529417`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.7970479452732633`, 
         1.8283891044109912`}, {-3.7970479452732633`, 1.8402317996712925`}}], 
        LineBox[{{-3.7970479452732633`, 
         1.8402317996712925`}, {-3.7970479452732633`, 1.851935885409871}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.7445609736580776`, 
         1.7185374484728435`}, {-3.7445609736580776`, 1.7366433023373513`}}], 
        LineBox[{{-3.7445609736580776`, 
         1.7366433023373513`}, {-3.7445609736580776`, 1.7544271557115294`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.6946925590696376`, 
         1.619534100146613}, {-3.6946925590696376`, 1.6304916630115016`}}], 
        LineBox[{{-3.6946925590696376`, 
         1.6304916630115016`}, {-3.6946925590696376`, 1.6413304579242867`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.647193798405784, 1.500603557784828}, {-3.647193798405784,
          1.5113017216832858`}}], 
        LineBox[{{-3.647193798405784, 
         1.5113017216832858`}, {-3.647193798405784, 1.521886645265807}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.5963690136318585`, 
         1.4280279764612096`}, {-3.5963690136318585`, 1.4397071262034546`}}], 
        LineBox[{{-3.5963690136318585`, 
         1.4397071262034546`}, {-3.5963690136318585`, 1.4512514465844122`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.5453141380980635`, 
         1.3047043217162122`}, {-3.5453141380980635`, 1.317818390210541}}], 
        LineBox[{{-3.5453141380980635`, 
         1.317818390210541}, {-3.5453141380980635`, 1.3307627036899459`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.4967816516117667`, 
         1.2117606124700808`}, {-3.4967816516117667`, 1.220750407258174}}], 
        LineBox[{{-3.4967816516117667`, 
         1.220750407258174}, {-3.4967816516117667`, 1.2296601051559222`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.445744518368156, 
         1.0916083461865123`}, {-3.445744518368156, 1.0975218249554692`}}], 
        LineBox[{{-3.445744518368156, 
         1.0975218249554692`}, {-3.445744518368156, 1.1034005399673055`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.3949116789514067`, 
         0.9936925948039551}, {-3.3949116789514067`, 1.0090572814052252`}}], 
        LineBox[{{-3.3949116789514067`, 
         1.0090572814052252`}, {-3.3949116789514067`, 1.0241894622849155`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.3465387336268324`, 
         0.8872014700684998}, {-3.3465387336268324`, 0.8943531688669267}}], 
        LineBox[{{-3.3465387336268324`, 
         0.8943531688669267}, {-3.3465387336268324`, 0.90145408384532}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.2963410320765485`, 
         0.7854089424673312}, {-3.2963410320765485`, 0.7948191622238685}}], 
        LineBox[{{-3.2963410320765485`, 
         0.7948191622238685}, {-3.2963410320765485`, 0.8041416546367885}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.244625779142534, 
         0.6688282198263341}, {-3.244625779142534, 0.6801846350739412}}], 
        LineBox[{{-3.244625779142534, 
         0.6801846350739412}, {-3.244625779142534, 0.6914135289844118}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.195454498404754, 
         0.5534869555896357}, {-3.195454498404754, 0.5655211208853126}}], 
        LineBox[{{-3.195454498404754, 
         0.5655211208853126}, {-3.195454498404754, 0.5774121854381664}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.1468430769836333`, 
         0.46460384520127856`}, {-3.1468430769836333`, 0.4747680401731179}}], 
        LineBox[{{-3.1468430769836333`, 
         0.4747680401731179}, {-3.1468430769836333`, 0.4848299629286564}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.097134772347408, 
         0.3388907561525857}, {-3.097134772347408, 0.34767696062634224`}}], 
        LineBox[{{-3.097134772347408, 
         0.34767696062634224`}, {-3.097134772347408, 0.35638663959179967`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.0465953406784982`, 
         0.23709258418056486`}, {-3.0465953406784982`, 
         0.24732717300357399`}}], 
        LineBox[{{-3.0465953406784982`, 
         0.24732717300357399`}, {-3.0465953406784982`, 
         0.25745807531116344`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.994268823040654, 
         0.1192697630268357}, {-2.994268823040654, 0.12918124899030498`}}], 
        LineBox[{{-2.994268823040654, 
         0.12918124899030498`}, {-2.994268823040654, 0.13899546074323016`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.9453650008726933`, 
         0.007813371229710387}, {-2.9453650008726933`, 0.01852004708493453}}],
         LineBox[{{-2.9453650008726933`, 
         0.01852004708493453}, {-2.9453650008726933`, 
         0.029113303307546946`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.917432257064329, -0.037395945995369245`}, \
{-2.917432257064329, -0.02841053904297403}}], 
        LineBox[{{-2.917432257064329, -0.02841053904297403}, \
{-2.917432257064329, -0.01950515115837279}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.6444443836852294`, -0.6658267298866025}, \
{-2.6444443836852294`, -0.6163922388315504}}], 
        LineBox[{{-2.6444443836852294`, -0.6163922388315504}, \
{-2.6444443836852294`, -0.5692868315248666}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.4487245335749988`, -1.0957259121114014`}, \
{-2.4487245335749988`, -1.0556986892846205`}}], 
        LineBox[{{-2.4487245335749988`, -1.0556986892846205`}, \
{-2.4487245335749988`, -1.0172121726105652`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.347387847945706, -1.3282513264020794`}, \
{-2.347387847945706, -1.2874633197730563`}}], 
        LineBox[{{-2.347387847945706, -1.2874633197730563`}, \
{-2.347387847945706, -1.2482739810831731`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.2553841482219026`, -1.5330680624972417`}, \
{-2.2553841482219026`, -1.4997443267671489`}}], 
        LineBox[{{-2.2553841482219026`, -1.4997443267671489`}, \
{-2.2553841482219026`, -1.4674953438648664`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.1984389311930306`, -1.6652082346301083`}, \
{-2.1984389311930306`, -1.6323694181875545`}}], 
        LineBox[{{-2.1984389311930306`, -1.6323694181875545`}, \
{-2.1984389311930306`, -1.6005747905345595`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.144562997373256, -1.7909769342208373`}, \
{-2.144562997373256, -1.7598879851040943`}}], 
        LineBox[{{-2.144562997373256, -1.7598879851040943`}, \
{-2.144562997373256, -1.7297364875849874`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.0934424039470523`, -1.9142673397810188`}, \
{-2.0934424039470523`, -1.883709346111293}}], 
        LineBox[{{-2.0934424039470523`, -1.883709346111293}, \
{-2.0934424039470523`, -1.8540575211414987`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.0448088291688524`, -2.030679039079973}, \
{-2.0448088291688524`, -2.0005884375940104`}}], 
        LineBox[{{-2.0448088291688524`, -2.0005884375940104`}, \
{-2.0448088291688524`, -1.9713768934298805`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.998431547349378, -2.139805142210923}, \
{-1.998431547349378, -2.1129221078909204`}}], 
        LineBox[{{-1.998431547349378, -2.1129221078909204`}, \
{-1.998431547349378, -2.086742891616604}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.9434261704597346`, -2.274706267308357}, \
{-1.9434261704597346`, -2.2441378664494818`}}], 
        LineBox[{{-1.9434261704597346`, -2.2441378664494818`}, \
{-1.9434261704597346`, -2.2144762425132947`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.8911076856443865`, -2.3985175095671787`}, \
{-1.8911076856443865`, -2.3731770660439384`}}], 
        LineBox[{{-1.8911076856443865`, -2.3731770660439384`}, \
{-1.8911076856443865`, -2.3484629225627245`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.8415558697159746`, -2.523866174228259}, \
{-1.8415558697159746`, -2.4949214965481983`}}], 
        LineBox[{{-1.8415558697159746`, -2.4949214965481983`}, \
{-1.8415558697159746`, -2.4667910993951443`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.794195067044452, -2.636012756413769}, \
{-1.794195067044452, -2.6123231874248036`}}], 
        LineBox[{{-1.794195067044452, -2.6123231874248036`}, \
{-1.794195067044452, -2.5891818517486516`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.749112569203864, -2.7523866326907167`}, \
{-1.749112569203864, -2.7254664461566005`}}], 
        LineBox[{{-1.749112569203864, -2.7254664461566005`}, \
{-1.749112569203864, -2.699251998933381}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.6974896181121244`, -2.883125737019028}, \
{-1.6974896181121244`, -2.857718858038654}}], 
        LineBox[{{-1.6974896181121244`, -2.857718858038654}, \
{-1.6974896181121244`, -2.832941526740773}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.6484017660376873`, -3.0072464747489995`}, \
{-1.6484017660376873`, -2.9836327753803844`}}], 
        LineBox[{{-1.6484017660376873`, -2.9836327753803844`}, \
{-1.6484017660376873`, -2.960563843561669}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.594088397426578, -3.151363193183176}, \
{-1.594088397426578, -3.1241326242959593`}}], 
        LineBox[{{-1.594088397426578, -3.1241326242959593`}, \
{-1.594088397426578, -3.0976239452427095`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.5424473593467354`, -3.2820670126181506`}, \
{-1.5424473593467354`, -3.2602355963400265`}}], 
        LineBox[{{-1.5424473593467354`, -3.2602355963400265`}, \
{-1.5424473593467354`, -3.23887062575828}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.493457846130768, -3.4158738161812936`}, \
{-1.493457846130768, -3.3916133331596203`}}], 
        LineBox[{{-1.493457846130768, -3.3916133331596203`}, \
{-1.493457846130768, -3.3679275072328214`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.4466528065688393`, -3.5377825084564627`}, \
{-1.4466528065688393`, -3.517454834967928}}], 
        LineBox[{{-1.4466528065688393`, -3.517454834967928}, \
{-1.4466528065688393`, -3.4975321568430324`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.4020363206488669`, -3.661847690753108}, \
{-1.4020363206488669`, -3.6390422597518133`}}], 
        LineBox[{{-1.4020363206488669`, -3.6390422597518133`}, \
{-1.4020363206488669`, -3.6167453411368107`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.3474454533915494`, -3.814270610398914}, \
{-1.3474454533915494`, -3.7909451201277533`}}], 
        LineBox[{{-1.3474454533915494`, -3.7909451201277533`}, \
{-1.3474454533915494`, -3.7681513297493674`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.2955821719692076`, -3.9543276763346142`}, \
{-1.2955821719692076`, -3.934701187335693}}], 
        LineBox[{{-1.2955821719692076`, -3.934701187335693}, \
{-1.2955821719692076`, -3.9154524944887386`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.24636706214148, -4.095259485683212}, {-1.24636706214148, \
-4.073301338365976}}], 
        LineBox[{{-1.24636706214148, -4.073301338365976}, {-1.24636706214148, \
-4.051815009571605}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.1943354736944491`, -4.245358295931416}, \
{-1.1943354736944491`, -4.224667104198138}}], 
        LineBox[{{-1.1943354736944491`, -4.224667104198138}, \
{-1.1943354736944491`, -4.2043953733951405`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.1448783782845262`, -4.388222942362424}, \
{-1.1448783782845262`, -4.367913539896439}}], 
        LineBox[{{-1.1448783782845262`, -4.367913539896439}, \
{-1.1448783782845262`, -4.348008412297119}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.0977528619957602`, -4.527404535721952}, \
{-1.0977528619957602`, -4.5068286369321715`}}], 
        LineBox[{{-1.0977528619957602`, -4.5068286369321715`}, \
{-1.0977528619957602`, -4.486667584262271}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.0483930806633872`, -4.675286330704212}, \
{-1.0483930806633872`, -4.655576675865791}}], 
        LineBox[{{-1.0483930806633872`, -4.655576675865791}, \
{-1.0483930806633872`, -4.636247994755012}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-0.9971493792545362, -4.83118648403724}, \
{-0.9971493792545362, -4.81195792240584}}], 
        LineBox[{{-0.9971493792545362, -4.81195792240584}, \
{-0.9971493792545362, -4.793092133721371}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-0.9484045818214244, -4.978215617221485}, \
{-0.9484045818214244, -4.959352094623877}}], 
        LineBox[{{-0.9484045818214244, -4.959352094623877}, \
{-0.9484045818214244, -4.940837826505711}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
    PointSize[0.015], Thickness[0.005], PointBox[CompressedData["
1:eJwVk/k/1HkcgMeYw8ww850xrHKUMx2rUKxK3y8iTYciyi01o7ZFciRLozbW
kZrYpkbHKl0bnaxdUZ83OcoVhVqDNiSU3Ne4tv3heT2v5w949ANDXYVkEom0
+xv/W7KmMFyTrgGaPxds2F+KEXrPr9K9avmQnuPKCD2GEZT26rrHUj5sT2Ap
BrwxQvVZY1l9IB+CTFwHxBhGnJmOjgg150Oap8le7CaHyLzo8K8bmQ9l87Ia
hQ2HWJhc0xxSpQ6xmZaXlO+zCZlw0UP8vDrY1s5D83Y28SbXJUkeqA7XzMh9
LRlqhHjPPk/hUnUoz/lpuqdUlfg6G2JSPc0Da5WsxzQHVSJocDLVvp4H7haC
56RKFnHc3emJnZQH5yyCfbX5LELTeZWzjT8PenfVJfj6MonwWQrX24IHuy8b
G2zrYxD0yyeCQ0k86BuVZ3GXM4gv6awkkyou3H1xsn19jAqxsVWRKpNyIZob
EifPpRMpjg9cE4RcOPXeXymMSifqd8Xb0s25wKSyPWL20Yj027l/35jCwHEm
PX0qk0rYZ4lVFpZjAAG12I48CtHho8dfnIFB9N3OmfMbKMSg9vEHx/Zh4OEs
VC4OUCa0nLMEyeYYOJOtmEvLycSxrldJrtMcWOLE7OQOKRHXxA7eWRIOiDQG
WmS6SkTXTjGuuZwDujHk8WARidBs+RQVVcWG7HPrblmVz+EBu11zvQLY0OIt
6JaGzeJWfbaBraNqkJNXHit4OY3bNw5MPjmjBhlnseDjmgr8wBWLofDvv7Wg
vkBgNonbr+Do+Zarwv2qfg8mYwJHh/64U+ujCtl74otfaIzha4Mu3DkwxQIR
c/1v5kkjeOaCxPgOCQukm9JY4WeH8L71LhGVpizwaojCFxgP4pXVcQsKypkw
EnooOeXqF/xIC0O1x48JO1LEF01De/G3QZt95kYZMLbF5xyv7CNuw8g/IpAw
wKzqC0JaHbjAZRlWvIIBzEchcbLAdrxGEHHxa4UKNF9ta/MgmvHUD6UBwf4q
8NCiKO/HO69wuUG4lcMoHSqKmuTkZMDH8NOJ2hI61ARYun4eT8c1tAwLuz3o
YJ68mnT7uyvIWJbo59hBg4M73SatP5egG5PmuuuP0mDd8KxrolU9co9dxTvF
pYHdG1FLztq3SEy/HnL5IRUcUy3CsP429MKEFPl6CRWiHQ9axxZ2ohUXBFfy
blHgtoi62Hh7D9JxuJX8gzsF4ho+XG1f8hlV3Et7JKdRwPd40OX+f/qRdHB/
54xUGZYlsF2MugaR3L03besKZVAsajBrKhlG/OwHm8IrycCWuRmGy0ZRgdCv
uVFEBkreBFPoM46sbI3e0Vhk0Lax7RmZm0AhDXEmQVIlkDzWF67UUyD/w5yb
mKkS3HCr2hZvOoPIC0yL/BAJ+D9vOZhrOIciGjYUlXmT4H5FycnVSiQQSR57
Z0zNoz1az/MdPpEgg+nIdNKaR4x+SJsbUQJK76C+wm4OGa0Ztts4Q4ans9c3
Kx+dRZ5adSLZmDIcvjTVQf1zBsVkUPIY3RRoUtWJ8p2ZRjr5Rl4ltVRYGvno
fZ/pNKKe3Jd/qZUGXXXFv7b4K1Cc/dbWmHY67NBobwo8MYXYz2o32MypwIi+
g3PbvUl00zlWNM5ngtPeIbXVHyfQ6IvG5TQDFmSo1x2MM55AK0sEPshQFbzk
nOynIeNobJnlqlIdNbjk99e4wdkxZMmYV5G7saHNSs8//8kooukWXtkY8+0j
zxyp3tAIKjY8fYKzBYOoRPEv89ojKIpnZMDpxuAuL2X20M5hFBlW4PYsmgvJ
1RrbhZIhZGDJ1Zyj8eBpY+5r64pBlBcxHefyOw8i57Prb/YMIPt3Lz+G4eqg
I30p2eX5FclVcGFAszr8B8I4nmU=
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, -6.907755278982122},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"I\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\) [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-6.907755278982137, 
   9.210340371976184}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233955640736`*^9},
 CellLabel->
  "Out[979]=",ExpressionUUID->"4ad0c12d-d410-4441-8fbe-1d3f25a2f414"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\DataMergedBinned.pdf\"\>"], \
"Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.918723396716563*^9},
 CellLabel->
  "Out[980]=",ExpressionUUID->"d68a566d-7317-4e6a-96e0-052936877f9f"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.256921585253977, 4.174065704710909}, {-5.256921585253977,
          4.189835529220337}}], 
        LineBox[{{-5.256921585253977, 4.189835529220337}, {-5.256921585253977,
          4.205360522318066}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.2005387488032095`, 
         4.073259742757601}, {-5.2005387488032095`, 4.118587632818974}}], 
        LineBox[{{-5.2005387488032095`, 
         4.118587632818974}, {-5.2005387488032095`, 4.16194969034683}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.147166472619123, 4.060316135610796}, {-5.147166472619123,
          4.089782626107377}}], 
        LineBox[{{-5.147166472619123, 4.089782626107377}, {-5.147166472619123,
          4.118405637625673}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.09649951504208, 4.003106248180086}, {-5.09649951504208, 
         4.01611303271202}}], 
        LineBox[{{-5.09649951504208, 4.01611303271202}, {-5.09649951504208, 
         4.028952810694088}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.048276729473299, 
         3.9389358153149536`}, {-5.048276729473299, 3.955597647650569}}], 
        LineBox[{{-5.048276729473299, 3.955597647650569}, {-5.048276729473299,
          3.9719864070116766`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-5.002273086667765, 
         3.8914024800279385`}, {-5.002273086667765, 3.903310392808608}}], 
        LineBox[{{-5.002273086667765, 3.903310392808608}, {-5.002273086667765,
          3.915078174238025}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.94768844245325, 3.8139079894512866`}, {-4.94768844245325,
          3.834967815887749}}], 
        LineBox[{{-4.94768844245325, 3.834967815887749}, {-4.94768844245325, 
         3.855593258362314}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.895750762859643, 
         3.7724277923240597`}, {-4.895750762859643, 3.788495548063706}}], 
        LineBox[{{-4.895750762859643, 3.788495548063706}, {-4.895750762859643,
          3.8043092083916625`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.846540574896795, 
         3.6680318725929815`}, {-4.846540574896795, 3.6971948892513216`}}], 
        LineBox[{{-4.846540574896795, 
         3.6971948892513216`}, {-4.846540574896795, 3.7255314688563543`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.7904256789098545`, 
         3.5807972114376416`}, {-4.7904256789098545`, 3.595170940641284}}], 
        LineBox[{{-4.7904256789098545`, 
         3.595170940641284}, {-4.7904256789098545`, 3.6093409899365225`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.745892143749627, 
         3.5305408348680896`}, {-4.745892143749627, 3.53272761870269}}], 
        LineBox[{{-4.745892143749627, 3.53272761870269}, {-4.745892143749627, 
         3.5349096309462915`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.703378855771098, 
         3.4590766095255976`}, {-4.703378855771098, 3.472169423772622}}], 
        LineBox[{{-4.703378855771098, 3.472169423772622}, {-4.703378855771098,
          3.4850930292675857`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.646735106032223, 3.364716685573411}, {-4.646735106032223,
          3.3848178194951477`}}], 
        LineBox[{{-4.646735106032223, 
         3.3848178194951477`}, {-4.646735106032223, 3.4045228469468096`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.592991950938105, 
         3.2732683619492975`}, {-4.592991950938105, 3.295588536605113}}], 
        LineBox[{{-4.592991950938105, 3.295588536605113}, {-4.592991950938105,
          3.3174213786240285`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.5491755160613705`, 
         3.229358754150528}, {-4.5491755160613705`, 3.2394049327590824`}}], 
        LineBox[{{-4.5491755160613705`, 
         3.2394049327590824`}, {-4.5491755160613705`, 3.2493511886722124`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.500425063167319, 
         3.1317298537854725`}, {-4.500425063167319, 3.1460297171712357`}}], 
        LineBox[{{-4.500425063167319, 
         3.1460297171712357`}, {-4.500425063167319, 3.1601279740230326`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.4474126107277066`, 
         3.0428963582873423`}, {-4.4474126107277066`, 3.059686411253172}}], 
        LineBox[{{-4.4474126107277066`, 
         3.059686411253172}, {-4.4474126107277066`, 3.076199207096457}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.397070109545044, 
         2.9463135772451974`}, {-4.397070109545044, 2.959403018876568}}], 
        LineBox[{{-4.397070109545044, 2.959403018876568}, {-4.397070109545044,
          2.972323338356772}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.349141399333698, 2.872285782580809}, {-4.349141399333698,
          2.877656946886363}}], 
        LineBox[{{-4.349141399333698, 2.877656946886363}, {-4.349141399333698,
          2.8829994158447265`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.297879181821557, 
         2.7824187941093794`}, {-4.297879181821557, 2.798573181441161}}], 
        LineBox[{{-4.297879181821557, 2.798573181441161}, {-4.297879181821557,
          2.81447074783161}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.243792424715041, 
         2.6838653228817315`}, {-4.243792424715041, 2.7006713343721764`}}], 
        LineBox[{{-4.243792424715041, 
         2.7006713343721764`}, {-4.243792424715041, 2.71719956578566}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.192482121267007, 
         2.5766830597560872`}, {-4.192482121267007, 2.587555056827199}}], 
        LineBox[{{-4.192482121267007, 2.587555056827199}, {-4.192482121267007,
          2.5983101237033623`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.143677057603073, 
         2.5204816973906157`}, {-4.143677057603073, 2.530559516618549}}], 
        LineBox[{{-4.143677057603073, 2.530559516618549}, {-4.143677057603073,
          2.5405367858878845`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.097143880912867, 2.413056266879144}, {-4.097143880912867,
          2.422233606842421}}], 
        LineBox[{{-4.097143880912867, 2.422233606842421}, {-4.097143880912867,
          2.431327488580964}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-4.048375288040937, 2.327698031247493}, {-4.048375288040937,
          2.3462696836216175`}}], 
        LineBox[{{-4.048375288040937, 
         2.3462696836216175`}, {-4.048375288040937, 2.3645027090308597`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.997716015667319, 2.226054796373329}, {-3.997716015667319,
          2.242709897757567}}], 
        LineBox[{{-3.997716015667319, 2.242709897757567}, {-3.997716015667319,
          2.259092144950021}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.9456183557485507`, 
         2.131347120083652}, {-3.9456183557485507`, 2.1394536117756386`}}], 
        LineBox[{{-3.9456183557485507`, 
         2.1394536117756386`}, {-3.9456183557485507`, 2.1474949163448325`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.896038528511996, 
         2.0374706798311664`}, {-3.896038528511996, 2.0500144214158937`}}], 
        LineBox[{{-3.896038528511996, 
         2.0500144214158937`}, {-3.896038528511996, 2.0624027648100802`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.8488587655549606`, 
         1.908393140892248}, {-3.8488587655549606`, 1.923147820803117}}], 
        LineBox[{{-3.8488587655549606`, 
         1.923147820803117}, {-3.8488587655549606`, 1.9376879617529417`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.7970479452732633`, 
         1.8283891044109912`}, {-3.7970479452732633`, 1.8402317996712925`}}], 
        LineBox[{{-3.7970479452732633`, 
         1.8402317996712925`}, {-3.7970479452732633`, 1.851935885409871}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.7445609736580776`, 
         1.7185374484728435`}, {-3.7445609736580776`, 1.7366433023373513`}}], 
        LineBox[{{-3.7445609736580776`, 
         1.7366433023373513`}, {-3.7445609736580776`, 1.7544271557115294`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.6946925590696376`, 
         1.619534100146613}, {-3.6946925590696376`, 1.6304916630115016`}}], 
        LineBox[{{-3.6946925590696376`, 
         1.6304916630115016`}, {-3.6946925590696376`, 1.6413304579242867`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.647193798405784, 1.500603557784828}, {-3.647193798405784,
          1.5113017216832858`}}], 
        LineBox[{{-3.647193798405784, 
         1.5113017216832858`}, {-3.647193798405784, 1.521886645265807}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.5963690136318585`, 
         1.4280279764612096`}, {-3.5963690136318585`, 1.4397071262034546`}}], 
        LineBox[{{-3.5963690136318585`, 
         1.4397071262034546`}, {-3.5963690136318585`, 1.4512514465844122`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.5453141380980635`, 
         1.3047043217162122`}, {-3.5453141380980635`, 1.317818390210541}}], 
        LineBox[{{-3.5453141380980635`, 
         1.317818390210541}, {-3.5453141380980635`, 1.3307627036899459`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.4967816516117667`, 
         1.2117606124700808`}, {-3.4967816516117667`, 1.220750407258174}}], 
        LineBox[{{-3.4967816516117667`, 
         1.220750407258174}, {-3.4967816516117667`, 1.2296601051559222`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.445744518368156, 
         1.0916083461865123`}, {-3.445744518368156, 1.0975218249554692`}}], 
        LineBox[{{-3.445744518368156, 
         1.0975218249554692`}, {-3.445744518368156, 1.1034005399673055`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.3949116789514067`, 
         0.9936925948039551}, {-3.3949116789514067`, 1.0090572814052252`}}], 
        LineBox[{{-3.3949116789514067`, 
         1.0090572814052252`}, {-3.3949116789514067`, 1.0241894622849155`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.3465387336268324`, 
         0.8872014700684998}, {-3.3465387336268324`, 0.8943531688669267}}], 
        LineBox[{{-3.3465387336268324`, 
         0.8943531688669267}, {-3.3465387336268324`, 0.90145408384532}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.2963410320765485`, 
         0.7854089424673312}, {-3.2963410320765485`, 0.7948191622238685}}], 
        LineBox[{{-3.2963410320765485`, 
         0.7948191622238685}, {-3.2963410320765485`, 0.8041416546367885}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.244625779142534, 
         0.6688282198263341}, {-3.244625779142534, 0.6801846350739412}}], 
        LineBox[{{-3.244625779142534, 
         0.6801846350739412}, {-3.244625779142534, 0.6914135289844118}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.195454498404754, 
         0.5534869555896357}, {-3.195454498404754, 0.5655211208853126}}], 
        LineBox[{{-3.195454498404754, 
         0.5655211208853126}, {-3.195454498404754, 0.5774121854381664}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.1468430769836333`, 
         0.46460384520127856`}, {-3.1468430769836333`, 0.4747680401731179}}], 
        LineBox[{{-3.1468430769836333`, 
         0.4747680401731179}, {-3.1468430769836333`, 0.4848299629286564}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.097134772347408, 
         0.3388907561525857}, {-3.097134772347408, 0.34767696062634224`}}], 
        LineBox[{{-3.097134772347408, 
         0.34767696062634224`}, {-3.097134772347408, 0.35638663959179967`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-3.0465953406784982`, 
         0.23709258418056486`}, {-3.0465953406784982`, 
         0.24732717300357399`}}], 
        LineBox[{{-3.0465953406784982`, 
         0.24732717300357399`}, {-3.0465953406784982`, 
         0.25745807531116344`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.994268823040654, 
         0.1192697630268357}, {-2.994268823040654, 0.12918124899030498`}}], 
        LineBox[{{-2.994268823040654, 
         0.12918124899030498`}, {-2.994268823040654, 0.13899546074323016`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.9453650008726933`, 
         0.007813371229710387}, {-2.9453650008726933`, 0.01852004708493453}}],
         LineBox[{{-2.9453650008726933`, 
         0.01852004708493453}, {-2.9453650008726933`, 
         0.029113303307546946`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.917432257064329, -0.037395945995369245`}, \
{-2.917432257064329, -0.02841053904297403}}], 
        LineBox[{{-2.917432257064329, -0.02841053904297403}, \
{-2.917432257064329, -0.01950515115837279}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.6444443836852294`, -0.6658267298866025}, \
{-2.6444443836852294`, -0.6163922388315504}}], 
        LineBox[{{-2.6444443836852294`, -0.6163922388315504}, \
{-2.6444443836852294`, -0.5692868315248666}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.4487245335749988`, -1.0957259121114014`}, \
{-2.4487245335749988`, -1.0556986892846205`}}], 
        LineBox[{{-2.4487245335749988`, -1.0556986892846205`}, \
{-2.4487245335749988`, -1.0172121726105652`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.347387847945706, -1.3282513264020794`}, \
{-2.347387847945706, -1.2874633197730563`}}], 
        LineBox[{{-2.347387847945706, -1.2874633197730563`}, \
{-2.347387847945706, -1.2482739810831731`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.2553841482219026`, -1.5330680624972417`}, \
{-2.2553841482219026`, -1.4997443267671489`}}], 
        LineBox[{{-2.2553841482219026`, -1.4997443267671489`}, \
{-2.2553841482219026`, -1.4674953438648664`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.1984389311930306`, -1.6652082346301083`}, \
{-2.1984389311930306`, -1.6323694181875545`}}], 
        LineBox[{{-2.1984389311930306`, -1.6323694181875545`}, \
{-2.1984389311930306`, -1.6005747905345595`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.144562997373256, -1.7909769342208373`}, \
{-2.144562997373256, -1.7598879851040943`}}], 
        LineBox[{{-2.144562997373256, -1.7598879851040943`}, \
{-2.144562997373256, -1.7297364875849874`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.0934424039470523`, -1.9142673397810188`}, \
{-2.0934424039470523`, -1.883709346111293}}], 
        LineBox[{{-2.0934424039470523`, -1.883709346111293}, \
{-2.0934424039470523`, -1.8540575211414987`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-2.0448088291688524`, -2.030679039079973}, \
{-2.0448088291688524`, -2.0005884375940104`}}], 
        LineBox[{{-2.0448088291688524`, -2.0005884375940104`}, \
{-2.0448088291688524`, -1.9713768934298805`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.998431547349378, -2.139805142210923}, \
{-1.998431547349378, -2.1129221078909204`}}], 
        LineBox[{{-1.998431547349378, -2.1129221078909204`}, \
{-1.998431547349378, -2.086742891616604}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.9434261704597346`, -2.274706267308357}, \
{-1.9434261704597346`, -2.2441378664494818`}}], 
        LineBox[{{-1.9434261704597346`, -2.2441378664494818`}, \
{-1.9434261704597346`, -2.2144762425132947`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.8911076856443865`, -2.3985175095671787`}, \
{-1.8911076856443865`, -2.3731770660439384`}}], 
        LineBox[{{-1.8911076856443865`, -2.3731770660439384`}, \
{-1.8911076856443865`, -2.3484629225627245`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.8415558697159746`, -2.523866174228259}, \
{-1.8415558697159746`, -2.4949214965481983`}}], 
        LineBox[{{-1.8415558697159746`, -2.4949214965481983`}, \
{-1.8415558697159746`, -2.4667910993951443`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.794195067044452, -2.636012756413769}, \
{-1.794195067044452, -2.6123231874248036`}}], 
        LineBox[{{-1.794195067044452, -2.6123231874248036`}, \
{-1.794195067044452, -2.5891818517486516`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.749112569203864, -2.7523866326907167`}, \
{-1.749112569203864, -2.7254664461566005`}}], 
        LineBox[{{-1.749112569203864, -2.7254664461566005`}, \
{-1.749112569203864, -2.699251998933381}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.6974896181121244`, -2.883125737019028}, \
{-1.6974896181121244`, -2.857718858038654}}], 
        LineBox[{{-1.6974896181121244`, -2.857718858038654}, \
{-1.6974896181121244`, -2.832941526740773}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.6484017660376873`, -3.0072464747489995`}, \
{-1.6484017660376873`, -2.9836327753803844`}}], 
        LineBox[{{-1.6484017660376873`, -2.9836327753803844`}, \
{-1.6484017660376873`, -2.960563843561669}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.594088397426578, -3.151363193183176}, \
{-1.594088397426578, -3.1241326242959593`}}], 
        LineBox[{{-1.594088397426578, -3.1241326242959593`}, \
{-1.594088397426578, -3.0976239452427095`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.5424473593467354`, -3.2820670126181506`}, \
{-1.5424473593467354`, -3.2602355963400265`}}], 
        LineBox[{{-1.5424473593467354`, -3.2602355963400265`}, \
{-1.5424473593467354`, -3.23887062575828}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.493457846130768, -3.4158738161812936`}, \
{-1.493457846130768, -3.3916133331596203`}}], 
        LineBox[{{-1.493457846130768, -3.3916133331596203`}, \
{-1.493457846130768, -3.3679275072328214`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.4466528065688393`, -3.5377825084564627`}, \
{-1.4466528065688393`, -3.517454834967928}}], 
        LineBox[{{-1.4466528065688393`, -3.517454834967928}, \
{-1.4466528065688393`, -3.4975321568430324`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.4020363206488669`, -3.661847690753108}, \
{-1.4020363206488669`, -3.6390422597518133`}}], 
        LineBox[{{-1.4020363206488669`, -3.6390422597518133`}, \
{-1.4020363206488669`, -3.6167453411368107`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.3474454533915494`, -3.814270610398914}, \
{-1.3474454533915494`, -3.7909451201277533`}}], 
        LineBox[{{-1.3474454533915494`, -3.7909451201277533`}, \
{-1.3474454533915494`, -3.7681513297493674`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.2955821719692076`, -3.9543276763346142`}, \
{-1.2955821719692076`, -3.934701187335693}}], 
        LineBox[{{-1.2955821719692076`, -3.934701187335693}, \
{-1.2955821719692076`, -3.9154524944887386`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.24636706214148, -4.095259485683212}, {-1.24636706214148, \
-4.073301338365976}}], 
        LineBox[{{-1.24636706214148, -4.073301338365976}, {-1.24636706214148, \
-4.051815009571605}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.1943354736944491`, -4.245358295931416}, \
{-1.1943354736944491`, -4.224667104198138}}], 
        LineBox[{{-1.1943354736944491`, -4.224667104198138}, \
{-1.1943354736944491`, -4.2043953733951405`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.1448783782845262`, -4.388222942362424}, \
{-1.1448783782845262`, -4.367913539896439}}], 
        LineBox[{{-1.1448783782845262`, -4.367913539896439}, \
{-1.1448783782845262`, -4.348008412297119}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.0977528619957602`, -4.527404535721952}, \
{-1.0977528619957602`, -4.5068286369321715`}}], 
        LineBox[{{-1.0977528619957602`, -4.5068286369321715`}, \
{-1.0977528619957602`, -4.486667584262271}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-1.0483930806633872`, -4.675286330704212}, \
{-1.0483930806633872`, -4.655576675865791}}], 
        LineBox[{{-1.0483930806633872`, -4.655576675865791}, \
{-1.0483930806633872`, -4.636247994755012}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-0.9971493792545362, -4.83118648403724}, \
{-0.9971493792545362, -4.81195792240584}}], 
        LineBox[{{-0.9971493792545362, -4.81195792240584}, \
{-0.9971493792545362, -4.793092133721371}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], 
     StyleBox[{{}, {
        LineBox[{{-0.9484045818214244, -4.978215617221485}, \
{-0.9484045818214244, -4.959352094623877}}], 
        LineBox[{{-0.9484045818214244, -4.959352094623877}, \
{-0.9484045818214244, -4.940837826505711}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
    PointSize[0.015], Thickness[0.005], PointBox[CompressedData["
1:eJwVk/k/1HkcgMeYw8ww850xrHKUMx2rUKxK3y8iTYciyi01o7ZFciRLozbW
kZrYpkbHKl0bnaxdUZ83OcoVhVqDNiSU3Ne4tv3heT2v5w949ANDXYVkEom0
+xv/W7KmMFyTrgGaPxds2F+KEXrPr9K9avmQnuPKCD2GEZT26rrHUj5sT2Ap
BrwxQvVZY1l9IB+CTFwHxBhGnJmOjgg150Oap8le7CaHyLzo8K8bmQ9l87Ia
hQ2HWJhc0xxSpQ6xmZaXlO+zCZlw0UP8vDrY1s5D83Y28SbXJUkeqA7XzMh9
LRlqhHjPPk/hUnUoz/lpuqdUlfg6G2JSPc0Da5WsxzQHVSJocDLVvp4H7haC
56RKFnHc3emJnZQH5yyCfbX5LELTeZWzjT8PenfVJfj6MonwWQrX24IHuy8b
G2zrYxD0yyeCQ0k86BuVZ3GXM4gv6awkkyou3H1xsn19jAqxsVWRKpNyIZob
EifPpRMpjg9cE4RcOPXeXymMSifqd8Xb0s25wKSyPWL20Yj027l/35jCwHEm
PX0qk0rYZ4lVFpZjAAG12I48CtHho8dfnIFB9N3OmfMbKMSg9vEHx/Zh4OEs
VC4OUCa0nLMEyeYYOJOtmEvLycSxrldJrtMcWOLE7OQOKRHXxA7eWRIOiDQG
WmS6SkTXTjGuuZwDujHk8WARidBs+RQVVcWG7HPrblmVz+EBu11zvQLY0OIt
6JaGzeJWfbaBraNqkJNXHit4OY3bNw5MPjmjBhlnseDjmgr8wBWLofDvv7Wg
vkBgNonbr+Do+Zarwv2qfg8mYwJHh/64U+ujCtl74otfaIzha4Mu3DkwxQIR
c/1v5kkjeOaCxPgOCQukm9JY4WeH8L71LhGVpizwaojCFxgP4pXVcQsKypkw
EnooOeXqF/xIC0O1x48JO1LEF01De/G3QZt95kYZMLbF5xyv7CNuw8g/IpAw
wKzqC0JaHbjAZRlWvIIBzEchcbLAdrxGEHHxa4UKNF9ta/MgmvHUD6UBwf4q
8NCiKO/HO69wuUG4lcMoHSqKmuTkZMDH8NOJ2hI61ARYun4eT8c1tAwLuz3o
YJ68mnT7uyvIWJbo59hBg4M73SatP5egG5PmuuuP0mDd8KxrolU9co9dxTvF
pYHdG1FLztq3SEy/HnL5IRUcUy3CsP429MKEFPl6CRWiHQ9axxZ2ohUXBFfy
blHgtoi62Hh7D9JxuJX8gzsF4ho+XG1f8hlV3Et7JKdRwPd40OX+f/qRdHB/
54xUGZYlsF2MugaR3L03besKZVAsajBrKhlG/OwHm8IrycCWuRmGy0ZRgdCv
uVFEBkreBFPoM46sbI3e0Vhk0Lax7RmZm0AhDXEmQVIlkDzWF67UUyD/w5yb
mKkS3HCr2hZvOoPIC0yL/BAJ+D9vOZhrOIciGjYUlXmT4H5FycnVSiQQSR57
Z0zNoz1az/MdPpEgg+nIdNKaR4x+SJsbUQJK76C+wm4OGa0Ztts4Q4ans9c3
Kx+dRZ5adSLZmDIcvjTVQf1zBsVkUPIY3RRoUtWJ8p2ZRjr5Rl4ltVRYGvno
fZ/pNKKe3Jd/qZUGXXXFv7b4K1Cc/dbWmHY67NBobwo8MYXYz2o32MypwIi+
g3PbvUl00zlWNM5ngtPeIbXVHyfQ6IvG5TQDFmSo1x2MM55AK0sEPshQFbzk
nOynIeNobJnlqlIdNbjk99e4wdkxZMmYV5G7saHNSs8//8kooukWXtkY8+0j
zxyp3tAIKjY8fYKzBYOoRPEv89ojKIpnZMDpxuAuL2X20M5hFBlW4PYsmgvJ
1RrbhZIhZGDJ1Zyj8eBpY+5r64pBlBcxHefyOw8i57Prb/YMIPt3Lz+G4eqg
I30p2eX5FclVcGFAszr8B8I4nmU=
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.438313143124173, -6.907755278982122},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"I\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\"(\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\"q\\\",\
FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*StyleBox[\\\")\\\",FontSlant->\\\"\
Italic\\\"]\\) [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000000000000000000000000000000], -69.07755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000000000000000000000000000], -64.47238260383328], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000000000000000000000000], -59.86721241784519], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000000000000000000000], -55.262042231857095`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000000000000000000000], -50.65687204586901], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000000000000000000], -46.051701859880914`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000000000000000], -41.44653167389282], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000000000000000], -36.841361487904734`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000000000000], -32.23619130191664], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000000000], -27.631021115928547`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000000000], -23.025850929940457`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000000], -18.420680743952367`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000000], 13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100000000], 18.420680743952367`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000000000], 23.025850929940457`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000000000000], 27.631021115928547`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100000000000000], 32.23619130191664], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000000000000000], 36.841361487904734`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000000000000000000], 41.44653167389282], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100000000000000000000], 46.051701859880914`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000000000000000000000], 50.65687204586901], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000000000000000000000000], 55.262042231857095`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100000000000000000000000000], 59.86721241784519], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000000000000000000000000000], 64.47238260383328], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000000000000000000000000000000], 69.07755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100000000000000000000000000000000], 73.68272297580947], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000000000000000000000000000000000], 78.28789316179756], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000000000000000000000000000000000000], 82.89306334778564], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100000000000000000000000000000000000000], 87.49823353377374], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000000000000000000000000000000000000000], 92.10340371976183], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10000], 9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20000], 9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30000], 10.308952660644293`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40000], 10.596634733096073`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50000], 10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60000], 11.002099841204238`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70000], 11.156250521031495`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80000], 11.289781913656018`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90000], 11.407564949312402`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.438313143124173, -0.9484045818214244}, {-6.907755278982137, 
   9.210340371976184}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233972634287`*^9},
 CellLabel->
  "Out[981]=",ExpressionUUID->"b66208f6-efaa-41e3-9d16-4dcb5ad8ddc7"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - \
number\\\\DataMergedBinnedLimited.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233986713715`*^9},
 CellLabel->
  "Out[982]=",ExpressionUUID->"00f56edf-7ac7-49b6-9e8f-3671a06a569d"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\Sample playground \
LH-ESRF-C21 NEW SAXS data merged.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233987600145`*^9},
 CellLabel->
  "Out[984]=",ExpressionUUID->"ab8d7222-ae28-48d7-bbfb-09f980bb33e0"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\Sample playground \
LH-ESRF-C21 NEW SAXS data merged and binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891497436223301*^9, 
   3.8914975686949873`*^9, {3.891498532036313*^9, 3.8914985683451767`*^9}, 
   3.891498623092783*^9, 3.891499326018267*^9, 3.891499357538082*^9, 
   3.8914994810548916`*^9, {3.8915022033282537`*^9, 3.8915022147763295`*^9}, 
   3.8916956593980885`*^9, 3.8916957067616215`*^9, 3.892609937927889*^9, 
   3.8926968102308693`*^9, 3.904715524488447*^9, 3.904715829623763*^9, 
   3.9047161163710537`*^9, 3.904718426388777*^9, {3.905852772893118*^9, 
   3.9058528218455796`*^9}, {3.905852879717977*^9, 3.9058529320993915`*^9}, 
   3.905916756244714*^9, 3.90591708559192*^9, 3.9156931838379407`*^9, 
   3.9156976578084946`*^9, 3.9175091235177784`*^9, 3.917513122187644*^9, 
   3.9175131685646076`*^9, 3.917513233598015*^9, 3.9186316698472166`*^9, 
   3.918642070620471*^9, 3.9186421317521825`*^9, 3.918642198096476*^9, 
   3.918723190477166*^9, {3.9187232865077753`*^9, 3.9187233100703173`*^9}, 
   3.9187233602036304`*^9, 3.9187233989555116`*^9},
 CellLabel->
  "Out[986]=",ExpressionUUID->"05ddb0f5-6b35-4a76-98e2-55cc1a1f27e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "3"}]}], ",", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "0"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
         "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotSlopes", ",", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8914993987113857`*^9, 3.89149940896005*^9}, {3.891695607264682*^9, 
   3.891695607536095*^9}, {3.9047155833160105`*^9, 3.9047156090081835`*^9}, {
   3.9047156482729816`*^9, 3.9047156625760326`*^9}, {3.9047157463014975`*^9, 
   3.9047157630602455`*^9}, {3.9047157933123603`*^9, 3.9047157976159916`*^9}},
 CellLabel->
  "In[966]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-5.1252793563099095`, -1.3528451653663944`}, \
{-5.1252793563099095`, -1.1433795214933027`}}], 
         LineBox[{{-5.1252793563099095`, -1.1433795214933027`}, \
{-5.1252793563099095`, -0.9339138776202109}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.972895007974446, -1.4467978539834505`}, \
{-4.972895007974446, -1.2260374126787217`}}], 
         LineBox[{{-4.972895007974446, -1.2260374126787217`}, \
{-4.972895007974446, -1.0052769713739929`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.8217116543319705`, -1.8090928756008526`}, \
{-4.8217116543319705`, -1.5870255304684209`}}], 
         LineBox[{{-4.8217116543319705`, -1.5870255304684209`}, \
{-4.8217116543319705`, -1.3649581853359891`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.673997009477748, -1.7201331254683612`}, \
{-4.673997009477748, -1.5072343590697368`}}], 
         LineBox[{{-4.673997009477748, -1.5072343590697368`}, \
{-4.673997009477748, -1.2943355926711124`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.5248234384963775`, -1.911503421821114}, \
{-4.5248234384963775`, -1.694867955095279}}], 
         LineBox[{{-4.5248234384963775`, -1.694867955095279}, \
{-4.5248234384963775`, -1.478232488369444}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.37075571259779, -1.9410342050813103`}, \
{-4.37075571259779, -1.7333780006790314`}}], 
         LineBox[{{-4.37075571259779, -1.7333780006790314`}, \
{-4.37075571259779, -1.5257217962767524`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.218821591988268, -2.025125721518314}, \
{-4.218821591988268, -1.8333400247972242`}}], 
         LineBox[{{-4.218821591988268, -1.8333400247972242`}, \
{-4.218821591988268, -1.6415543280761344`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-4.0694770795907385`, -2.0338505814348116`}, \
{-4.0694770795907385`, -1.8415704137385887`}}], 
         LineBox[{{-4.0694770795907385`, -1.8415704137385887`}, \
{-4.0694770795907385`, -1.6492902460423657`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.918560524201742, -2.232652532918944}, \
{-3.918560524201742, -2.037689312909757}}], 
         LineBox[{{-3.918560524201742, -2.037689312909757}, \
{-3.918560524201742, -1.8427260929005702`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.7690418430970776`, -2.2469329242210914`}, \
{-3.7690418430970776`, -2.050470813269418}}], 
         LineBox[{{-3.7690418430970776`, -2.050470813269418}, \
{-3.7690418430970776`, -1.8540087023177443`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.620833185567976, -2.1924751125763615`}, \
{-3.620833185567976, -2.0078450826643963`}}], 
         LineBox[{{-3.620833185567976, -2.0078450826643963`}, \
{-3.620833185567976, -1.823215052752431}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.4709577855367924`, -2.327943111848826}, \
{-3.4709577855367924`, -2.1672420250239024`}}], 
         LineBox[{{-3.4709577855367924`, -2.1672420250239024`}, \
{-3.4709577855367924`, -2.0065409381989787`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.320602706761705, -2.2819923140511977`}, \
{-3.320602706761705, -2.130575773770181}}], 
         LineBox[{{-3.320602706761705, -2.130575773770181}, \
{-3.320602706761705, -1.9791592334891646`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.170051886202171, -2.325960853381056}, \
{-3.170051886202171, -2.178668004677789}}], 
         LineBox[{{-3.170051886202171, -2.178668004677789}, \
{-3.170051886202171, -2.031375155974522}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-3.030477377590662, -2.364963478329096}, \
{-3.030477377590662, -2.215833089497624}}], 
         LineBox[{{-3.030477377590662, -2.215833089497624}, \
{-3.030477377590662, -2.066702700666152}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-2.8877051576271007`, -2.4470810453712706`}, \
{-2.8877051576271007`, -2.0308235141317508`}}], 
         LineBox[{{-2.8877051576271007`, -2.0308235141317508`}, \
{-2.8877051576271007`, -1.614565982892231}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-2.7272330204080557`, -2.765905625269932}, \
{-2.7272330204080557`, -2.2167173422497792`}}], 
         LineBox[{{-2.7272330204080557`, -2.2167173422497792`}, \
{-2.7272330204080557`, -1.6675290592296266`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-2.5654914303840752`, -2.7566653381080948`}, \
{-2.5654914303840752`, -2.242092245770433}}], 
         LineBox[{{-2.5654914303840752`, -2.242092245770433}, \
{-2.5654914303840752`, -1.727519153432771}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-2.4167532824388296`, -2.7966935161724824`}, \
{-2.4167532824388296`, -2.2729773346218276`}}], 
         LineBox[{{-2.4167532824388296`, -2.2729773346218276`}, \
{-2.4167532824388296`, -1.7492611530711728`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-2.273683103959538, -2.7892211361624484`}, \
{-2.273683103959538, -2.320537873341196}}], 
         LineBox[{{-2.273683103959538, -2.320537873341196}, \
{-2.273683103959538, -1.8518546105199438`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-2.1225114762089117`, -2.8236710408799715`}, \
{-2.1225114762089117`, -2.3937844289603167`}}], 
         LineBox[{{-2.1225114762089117`, -2.3937844289603167`}, \
{-2.1225114762089117`, -1.9638978170406618`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.9688530566493743`, -2.8229541872537505`}, \
{-1.9688530566493743`, -2.420665764815222}}], 
         LineBox[{{-1.9688530566493743`, -2.420665764815222}, \
{-1.9688530566493743`, -2.0183773423766933`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.8165848867407983`, -2.8752021559189758`}, \
{-1.8165848867407983`, -2.490287621993528}}], 
         LineBox[{{-1.8165848867407983`, -2.490287621993528}, \
{-1.8165848867407983`, -2.1053730880680805`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.6679573417952833`, -2.943694442125146}, \
{-1.6679573417952833`, -2.573234246260398}}], 
         LineBox[{{-1.6679573417952833`, -2.573234246260398}, \
{-1.6679573417952833`, -2.20277405039565}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.5211693704213907`, -3.0180240138702534`}, \
{-1.5211693704213907`, -2.666104615926631}}], 
         LineBox[{{-1.5211693704213907`, -2.666104615926631}, \
{-1.5211693704213907`, -2.3141852179830082`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.371988295897768, -3.092946448022707}, \
{-1.371988295897768, -2.7627217465836353`}}], 
         LineBox[{{-1.371988295897768, -2.7627217465836353`}, \
{-1.371988295897768, -2.4324970451445638`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.2210917594318125`, -3.1916284426259494`}, \
{-1.2210917594318125`, -2.8740183095344505`}}], 
         LineBox[{{-1.2210917594318125`, -2.8740183095344505`}, \
{-1.2210917594318125`, -2.5564081764429516`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{{}, {
         LineBox[{{-1.0718189592856806`, -3.3051122988253487`}, \
{-1.0718189592856806`, -2.996429944455006}}], 
         LineBox[{{-1.0718189592856806`, -2.996429944455006}, \
{-1.0718189592856806`, -2.6877475900846637`}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.1252793563099095`, -0.9339138776202109}, 
            Offset[{3, 
             0}, {-5.1252793563099095`, -0.9339138776202109}]}, \
{{-5.1252793563099095`, -0.9339138776202109}, 
            Offset[{-3, 
             0}, {-5.1252793563099095`, -0.9339138776202109}]}, \
{{-5.1252793563099095`, -1.3528451653663944`}, 
            Offset[{3, 
             0}, {-5.1252793563099095`, -1.3528451653663944`}]}, \
{{-5.1252793563099095`, -1.3528451653663944`}, 
            Offset[{-3, 
             0}, {-5.1252793563099095`, -1.3528451653663944`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.972895007974446, -1.0052769713739929`}, 
            Offset[{3, 
             0}, {-4.972895007974446, -1.0052769713739929`}]}, \
{{-4.972895007974446, -1.0052769713739929`}, 
            Offset[{-3, 
             0}, {-4.972895007974446, -1.0052769713739929`}]}, \
{{-4.972895007974446, -1.4467978539834505`}, 
            Offset[{3, 
             0}, {-4.972895007974446, -1.4467978539834505`}]}, \
{{-4.972895007974446, -1.4467978539834505`}, 
            Offset[{-3, 
             0}, {-4.972895007974446, -1.4467978539834505`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.8217116543319705`, -1.3649581853359891`}, 
            Offset[{3, 
             0}, {-4.8217116543319705`, -1.3649581853359891`}]}, \
{{-4.8217116543319705`, -1.3649581853359891`}, 
            Offset[{-3, 
             0}, {-4.8217116543319705`, -1.3649581853359891`}]}, \
{{-4.8217116543319705`, -1.8090928756008526`}, 
            Offset[{3, 
             0}, {-4.8217116543319705`, -1.8090928756008526`}]}, \
{{-4.8217116543319705`, -1.8090928756008526`}, 
            Offset[{-3, 
             0}, {-4.8217116543319705`, -1.8090928756008526`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.673997009477748, -1.2943355926711124`}, 
            Offset[{3, 
             0}, {-4.673997009477748, -1.2943355926711124`}]}, \
{{-4.673997009477748, -1.2943355926711124`}, 
            Offset[{-3, 
             0}, {-4.673997009477748, -1.2943355926711124`}]}, \
{{-4.673997009477748, -1.7201331254683612`}, 
            Offset[{3, 
             0}, {-4.673997009477748, -1.7201331254683612`}]}, \
{{-4.673997009477748, -1.7201331254683612`}, 
            Offset[{-3, 
             0}, {-4.673997009477748, -1.7201331254683612`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.5248234384963775`, -1.478232488369444}, 
            Offset[{3, 
             0}, {-4.5248234384963775`, -1.478232488369444}]}, \
{{-4.5248234384963775`, -1.478232488369444}, 
            Offset[{-3, 
             0}, {-4.5248234384963775`, -1.478232488369444}]}, \
{{-4.5248234384963775`, -1.911503421821114}, 
            Offset[{3, 
             0}, {-4.5248234384963775`, -1.911503421821114}]}, \
{{-4.5248234384963775`, -1.911503421821114}, 
            Offset[{-3, 
             0}, {-4.5248234384963775`, -1.911503421821114}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.37075571259779, -1.5257217962767524`}, 
            Offset[{3, 
             0}, {-4.37075571259779, -1.5257217962767524`}]}, \
{{-4.37075571259779, -1.5257217962767524`}, 
            Offset[{-3, 
             0}, {-4.37075571259779, -1.5257217962767524`}]}, \
{{-4.37075571259779, -1.9410342050813103`}, 
            Offset[{3, 
             0}, {-4.37075571259779, -1.9410342050813103`}]}, \
{{-4.37075571259779, -1.9410342050813103`}, 
            Offset[{-3, 0}, {-4.37075571259779, -1.9410342050813103`}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.218821591988268, -1.6415543280761344`}, 
            Offset[{3, 
             0}, {-4.218821591988268, -1.6415543280761344`}]}, \
{{-4.218821591988268, -1.6415543280761344`}, 
            Offset[{-3, 
             0}, {-4.218821591988268, -1.6415543280761344`}]}, \
{{-4.218821591988268, -2.025125721518314}, 
            Offset[{3, 
             0}, {-4.218821591988268, -2.025125721518314}]}, \
{{-4.218821591988268, -2.025125721518314}, 
            Offset[{-3, 0}, {-4.218821591988268, -2.025125721518314}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.0694770795907385`, -1.6492902460423657`}, 
            Offset[{3, 
             0}, {-4.0694770795907385`, -1.6492902460423657`}]}, \
{{-4.0694770795907385`, -1.6492902460423657`}, 
            Offset[{-3, 
             0}, {-4.0694770795907385`, -1.6492902460423657`}]}, \
{{-4.0694770795907385`, -2.0338505814348116`}, 
            Offset[{3, 
             0}, {-4.0694770795907385`, -2.0338505814348116`}]}, \
{{-4.0694770795907385`, -2.0338505814348116`}, 
            Offset[{-3, 
             0}, {-4.0694770795907385`, -2.0338505814348116`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.918560524201742, -1.8427260929005702`}, 
            Offset[{3, 
             0}, {-3.918560524201742, -1.8427260929005702`}]}, \
{{-3.918560524201742, -1.8427260929005702`}, 
            Offset[{-3, 
             0}, {-3.918560524201742, -1.8427260929005702`}]}, \
{{-3.918560524201742, -2.232652532918944}, 
            Offset[{3, 
             0}, {-3.918560524201742, -2.232652532918944}]}, \
{{-3.918560524201742, -2.232652532918944}, 
            Offset[{-3, 0}, {-3.918560524201742, -2.232652532918944}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.7690418430970776`, -1.8540087023177443`}, 
            Offset[{3, 
             0}, {-3.7690418430970776`, -1.8540087023177443`}]}, \
{{-3.7690418430970776`, -1.8540087023177443`}, 
            Offset[{-3, 
             0}, {-3.7690418430970776`, -1.8540087023177443`}]}, \
{{-3.7690418430970776`, -2.2469329242210914`}, 
            Offset[{3, 
             0}, {-3.7690418430970776`, -2.2469329242210914`}]}, \
{{-3.7690418430970776`, -2.2469329242210914`}, 
            Offset[{-3, 
             0}, {-3.7690418430970776`, -2.2469329242210914`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.620833185567976, -1.823215052752431}, 
            Offset[{3, 
             0}, {-3.620833185567976, -1.823215052752431}]}, \
{{-3.620833185567976, -1.823215052752431}, 
            Offset[{-3, 
             0}, {-3.620833185567976, -1.823215052752431}]}, \
{{-3.620833185567976, -2.1924751125763615`}, 
            Offset[{3, 
             0}, {-3.620833185567976, -2.1924751125763615`}]}, \
{{-3.620833185567976, -2.1924751125763615`}, 
            Offset[{-3, 
             0}, {-3.620833185567976, -2.1924751125763615`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.4709577855367924`, -2.0065409381989787`}, 
            Offset[{3, 
             0}, {-3.4709577855367924`, -2.0065409381989787`}]}, \
{{-3.4709577855367924`, -2.0065409381989787`}, 
            Offset[{-3, 
             0}, {-3.4709577855367924`, -2.0065409381989787`}]}, \
{{-3.4709577855367924`, -2.327943111848826}, 
            Offset[{3, 
             0}, {-3.4709577855367924`, -2.327943111848826}]}, \
{{-3.4709577855367924`, -2.327943111848826}, 
            Offset[{-3, 
             0}, {-3.4709577855367924`, -2.327943111848826}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.320602706761705, -1.9791592334891646`}, 
            Offset[{3, 
             0}, {-3.320602706761705, -1.9791592334891646`}]}, \
{{-3.320602706761705, -1.9791592334891646`}, 
            Offset[{-3, 
             0}, {-3.320602706761705, -1.9791592334891646`}]}, \
{{-3.320602706761705, -2.2819923140511977`}, 
            Offset[{3, 
             0}, {-3.320602706761705, -2.2819923140511977`}]}, \
{{-3.320602706761705, -2.2819923140511977`}, 
            Offset[{-3, 
             0}, {-3.320602706761705, -2.2819923140511977`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.170051886202171, -2.031375155974522}, 
            Offset[{3, 
             0}, {-3.170051886202171, -2.031375155974522}]}, \
{{-3.170051886202171, -2.031375155974522}, 
            Offset[{-3, 
             0}, {-3.170051886202171, -2.031375155974522}]}, \
{{-3.170051886202171, -2.325960853381056}, 
            Offset[{3, 
             0}, {-3.170051886202171, -2.325960853381056}]}, \
{{-3.170051886202171, -2.325960853381056}, 
            Offset[{-3, 0}, {-3.170051886202171, -2.325960853381056}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.030477377590662, -2.066702700666152}, 
            Offset[{3, 
             0}, {-3.030477377590662, -2.066702700666152}]}, \
{{-3.030477377590662, -2.066702700666152}, 
            Offset[{-3, 
             0}, {-3.030477377590662, -2.066702700666152}]}, \
{{-3.030477377590662, -2.364963478329096}, 
            Offset[{3, 
             0}, {-3.030477377590662, -2.364963478329096}]}, \
{{-3.030477377590662, -2.364963478329096}, 
            Offset[{-3, 0}, {-3.030477377590662, -2.364963478329096}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.8877051576271007`, -1.614565982892231}, 
            Offset[{3, 
             0}, {-2.8877051576271007`, -1.614565982892231}]}, \
{{-2.8877051576271007`, -1.614565982892231}, 
            Offset[{-3, 
             0}, {-2.8877051576271007`, -1.614565982892231}]}, \
{{-2.8877051576271007`, -2.4470810453712706`}, 
            Offset[{3, 
             0}, {-2.8877051576271007`, -2.4470810453712706`}]}, \
{{-2.8877051576271007`, -2.4470810453712706`}, 
            Offset[{-3, 
             0}, {-2.8877051576271007`, -2.4470810453712706`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.7272330204080557`, -1.6675290592296266`}, 
            Offset[{3, 
             0}, {-2.7272330204080557`, -1.6675290592296266`}]}, \
{{-2.7272330204080557`, -1.6675290592296266`}, 
            Offset[{-3, 
             0}, {-2.7272330204080557`, -1.6675290592296266`}]}, \
{{-2.7272330204080557`, -2.765905625269932}, 
            Offset[{3, 
             0}, {-2.7272330204080557`, -2.765905625269932}]}, \
{{-2.7272330204080557`, -2.765905625269932}, 
            Offset[{-3, 
             0}, {-2.7272330204080557`, -2.765905625269932}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.5654914303840752`, -1.727519153432771}, 
            Offset[{3, 
             0}, {-2.5654914303840752`, -1.727519153432771}]}, \
{{-2.5654914303840752`, -1.727519153432771}, 
            Offset[{-3, 
             0}, {-2.5654914303840752`, -1.727519153432771}]}, \
{{-2.5654914303840752`, -2.7566653381080948`}, 
            Offset[{3, 
             0}, {-2.5654914303840752`, -2.7566653381080948`}]}, \
{{-2.5654914303840752`, -2.7566653381080948`}, 
            Offset[{-3, 
             0}, {-2.5654914303840752`, -2.7566653381080948`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4167532824388296`, -1.7492611530711728`}, 
            Offset[{3, 
             0}, {-2.4167532824388296`, -1.7492611530711728`}]}, \
{{-2.4167532824388296`, -1.7492611530711728`}, 
            Offset[{-3, 
             0}, {-2.4167532824388296`, -1.7492611530711728`}]}, \
{{-2.4167532824388296`, -2.7966935161724824`}, 
            Offset[{3, 
             0}, {-2.4167532824388296`, -2.7966935161724824`}]}, \
{{-2.4167532824388296`, -2.7966935161724824`}, 
            Offset[{-3, 
             0}, {-2.4167532824388296`, -2.7966935161724824`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.273683103959538, -1.8518546105199438`}, 
            Offset[{3, 
             0}, {-2.273683103959538, -1.8518546105199438`}]}, \
{{-2.273683103959538, -1.8518546105199438`}, 
            Offset[{-3, 
             0}, {-2.273683103959538, -1.8518546105199438`}]}, \
{{-2.273683103959538, -2.7892211361624484`}, 
            Offset[{3, 
             0}, {-2.273683103959538, -2.7892211361624484`}]}, \
{{-2.273683103959538, -2.7892211361624484`}, 
            Offset[{-3, 
             0}, {-2.273683103959538, -2.7892211361624484`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1225114762089117`, -1.9638978170406618`}, 
            Offset[{3, 
             0}, {-2.1225114762089117`, -1.9638978170406618`}]}, \
{{-2.1225114762089117`, -1.9638978170406618`}, 
            Offset[{-3, 
             0}, {-2.1225114762089117`, -1.9638978170406618`}]}, \
{{-2.1225114762089117`, -2.8236710408799715`}, 
            Offset[{3, 
             0}, {-2.1225114762089117`, -2.8236710408799715`}]}, \
{{-2.1225114762089117`, -2.8236710408799715`}, 
            Offset[{-3, 
             0}, {-2.1225114762089117`, -2.8236710408799715`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9688530566493743`, -2.0183773423766933`}, 
            Offset[{3, 
             0}, {-1.9688530566493743`, -2.0183773423766933`}]}, \
{{-1.9688530566493743`, -2.0183773423766933`}, 
            Offset[{-3, 
             0}, {-1.9688530566493743`, -2.0183773423766933`}]}, \
{{-1.9688530566493743`, -2.8229541872537505`}, 
            Offset[{3, 
             0}, {-1.9688530566493743`, -2.8229541872537505`}]}, \
{{-1.9688530566493743`, -2.8229541872537505`}, 
            Offset[{-3, 
             0}, {-1.9688530566493743`, -2.8229541872537505`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.8165848867407983`, -2.1053730880680805`}, 
            Offset[{3, 
             0}, {-1.8165848867407983`, -2.1053730880680805`}]}, \
{{-1.8165848867407983`, -2.1053730880680805`}, 
            Offset[{-3, 
             0}, {-1.8165848867407983`, -2.1053730880680805`}]}, \
{{-1.8165848867407983`, -2.8752021559189758`}, 
            Offset[{3, 
             0}, {-1.8165848867407983`, -2.8752021559189758`}]}, \
{{-1.8165848867407983`, -2.8752021559189758`}, 
            Offset[{-3, 
             0}, {-1.8165848867407983`, -2.8752021559189758`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.6679573417952833`, -2.20277405039565}, 
            Offset[{3, 
             0}, {-1.6679573417952833`, -2.20277405039565}]}, \
{{-1.6679573417952833`, -2.20277405039565}, 
            Offset[{-3, 
             0}, {-1.6679573417952833`, -2.20277405039565}]}, \
{{-1.6679573417952833`, -2.943694442125146}, 
            Offset[{3, 
             0}, {-1.6679573417952833`, -2.943694442125146}]}, \
{{-1.6679573417952833`, -2.943694442125146}, 
            Offset[{-3, 
             0}, {-1.6679573417952833`, -2.943694442125146}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.5211693704213907`, -2.3141852179830082`}, 
            Offset[{3, 
             0}, {-1.5211693704213907`, -2.3141852179830082`}]}, \
{{-1.5211693704213907`, -2.3141852179830082`}, 
            Offset[{-3, 
             0}, {-1.5211693704213907`, -2.3141852179830082`}]}, \
{{-1.5211693704213907`, -3.0180240138702534`}, 
            Offset[{3, 
             0}, {-1.5211693704213907`, -3.0180240138702534`}]}, \
{{-1.5211693704213907`, -3.0180240138702534`}, 
            Offset[{-3, 
             0}, {-1.5211693704213907`, -3.0180240138702534`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.371988295897768, -2.4324970451445638`}, 
            Offset[{3, 
             0}, {-1.371988295897768, -2.4324970451445638`}]}, \
{{-1.371988295897768, -2.4324970451445638`}, 
            Offset[{-3, 
             0}, {-1.371988295897768, -2.4324970451445638`}]}, \
{{-1.371988295897768, -3.092946448022707}, 
            Offset[{3, 
             0}, {-1.371988295897768, -3.092946448022707}]}, \
{{-1.371988295897768, -3.092946448022707}, 
            Offset[{-3, 0}, {-1.371988295897768, -3.092946448022707}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.2210917594318125`, -2.5564081764429516`}, 
            Offset[{3, 
             0}, {-1.2210917594318125`, -2.5564081764429516`}]}, \
{{-1.2210917594318125`, -2.5564081764429516`}, 
            Offset[{-3, 
             0}, {-1.2210917594318125`, -2.5564081764429516`}]}, \
{{-1.2210917594318125`, -3.1916284426259494`}, 
            Offset[{3, 
             0}, {-1.2210917594318125`, -3.1916284426259494`}]}, \
{{-1.2210917594318125`, -3.1916284426259494`}, 
            Offset[{-3, 
             0}, {-1.2210917594318125`, -3.1916284426259494`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.015], Thickness[0.005], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.0718189592856806`, -2.6877475900846637`}, 
            Offset[{3, 
             0}, {-1.0718189592856806`, -2.6877475900846637`}]}, \
{{-1.0718189592856806`, -2.6877475900846637`}, 
            Offset[{-3, 
             0}, {-1.0718189592856806`, -2.6877475900846637`}]}, \
{{-1.0718189592856806`, -3.3051122988253487`}, 
            Offset[{3, 
             0}, {-1.0718189592856806`, -3.3051122988253487`}]}, \
{{-1.0718189592856806`, -3.3051122988253487`}, 
            Offset[{-3, 
             0}, {-1.0718189592856806`, -3.3051122988253487`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
     PointSize[0.015], Thickness[0.005], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJ9xIO0mAFMCGrTtTSEvyv4PExpY+
5BPAggryZ9md8784ZKjHbkkTwHR29OF0ZPm/JDylRSyyEsDrynnGoR34v5kQ
wlBrGRLADcNi3C0e+7+WprFip3sRwF1bCJLqu/u/Ov50xBLgEMADO49ZXFX9
v76n4v8kRxDAZp3EiRJ3/b+qvpZCNlkPwFTZ8g0wTQDAL9zqaP8mDsBKKOM9
XWcAwKNJomN39wzA8dIrFREQAMC2avWDhcQLwK/0n/yCVgHAomfkJpiQCsBN
8a9PawsBwDrkzilEXAnAIHanfeltAcBsKGDsaj4IwKVL5rIGugHAy/1jKQUa
B8A5JglmID8AwIzKuYtf0QXAv4JLTda7AcDJV/1eIIYEwPiXMQ/O7wHAeJq0
voJVA8D//6W9Di8CwLjKZ8SAMALA4wkZKXaQAsCcnf1L5/oAwAF4YHN4JgPA
6AQPEGyA/7/3bDMDhl0DwH5ab1C7EP2/OsSw6hvsA8AxJKIJ9K/6v8AVJdb7
lQTAQzCasbVW+L/H9CioLlQFwM4C1v+p8/W/nTLs2w0aBsC2y0KDl4nzvwNy
vE/9/QbACNYVoysm8b/Jg0FDsPgHwJpU4k8=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{367.456787109375, Automatic},
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-5., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.891695668002462*^9, 3.8916957133130064`*^9, 
   3.892609945755599*^9, 3.892696818117037*^9, 3.9047156111639433`*^9, {
   3.9047156504368753`*^9, 3.9047156552465687`*^9}, {3.9047157575401344`*^9, 
   3.9047157637266335`*^9}, 3.904715798675607*^9, {3.915693191226008*^9, 
   3.915693204809351*^9}, 3.915697662638813*^9, 3.918723325054222*^9, 
   3.9187233688879976`*^9},
 CellLabel->
  "Out[966]=",ExpressionUUID->"b3405736-8eb8-4658-941c-0fc3359f976a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.891695668002462*^9, 3.8916957133130064`*^9, 
   3.892609945755599*^9, 3.892696818117037*^9, 3.9047156111639433`*^9, {
   3.9047156504368753`*^9, 3.9047156552465687`*^9}, {3.9047157575401344`*^9, 
   3.9047157637266335`*^9}, 3.904715798675607*^9, {3.915693191226008*^9, 
   3.915693204809351*^9}, 3.915697662638813*^9, 3.918723325054222*^9, 
   3.918723371009242*^9},
 CellLabel->
  "Out[967]=",ExpressionUUID->"247dfacb-1581-4c1b-a3c9-163fda2e46f1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.005944556475133113`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.14", "0.21"},
       "Around"],
      Around[-1.1433795214933027`, 0.20946564387309177`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006923076633269746`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.23", "0.22"},
       "Around"],
      Around[-1.2260374126787217`, 0.22076044130472885`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008052991398086013`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.59", "0.22"},
       "Around"],
      Around[-1.5870255304684209`, 0.22206734513243168`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.009334883243317578`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.51", "0.21"},
       "Around"],
      Around[-1.5072343590697368`, 0.21289876639862432`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010836627598798816`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.69", "0.22"},
       "Around"],
      Around[-1.694867955095279, 0.21663546672583503`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.012641683477791973`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.73", "0.21"},
       "Around"],
      Around[-1.7333780006790314`, 0.20765620440227886`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.014715975714960769`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.83", "0.19"},
       "Around"],
      Around[-1.8333400247972242`, 0.19178569672108986`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01708632095774898`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.84", "0.19"},
       "Around"],
      Around[-1.8415704137385887`, 0.19228016769622283`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.01986967608620542`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.04", "0.19"},
       "Around"],
      Around[-2.037689312909757, 0.1949632200091869]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02307416136581348`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.05", "0.20"},
       "Around"],
      Around[-2.050470813269418, 0.19646211095167346`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.026760370846774233`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.01", "0.18"},
       "Around"],
      Around[-2.0078450826643963`, 0.18463002991196534`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.031087241487242963`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.16"},
       "Around"],
      Around[-2.1672420250239024`, 0.16070108682492373`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.036131048762930884`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.13", "0.15"},
       "Around"],
      Around[-2.130575773770181, 0.15141654028101667`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04200141855281242`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.18", "0.15"},
       "Around"],
      Around[-2.178668004677789, 0.14729284870326684`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04829257882758194`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.22", "0.15"},
       "Around"],
      Around[-2.215833089497624, 0.14913038883147195`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05570389771166262`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.0", "0.4"},
       "Around"],
      Around[-2.0308235141317508`, 0.41625753123951975`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06540000000725471`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.2167173422497792`, 0.5491882830201528]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07688139030557264`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.242092245770433, 0.5145730923376619]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08921079001314548`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.2729773346218276`, 0.5237161815506549]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.10293237045209665`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.320537873341196, 0.4686832628212522]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1197305501659388`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.3937844289603167`, 0.42988661191965494`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13961689709035063`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.420665764815222, 0.40228842243852875`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1625800331537905`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.5", "0.4"},
       "Around"],
      Around[-2.490287621993528, 0.3849145339254478]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18863198304539955`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.6", "0.4"},
       "Around"],
      Around[-2.573234246260398, 0.37046019586474804`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.21845628121882524`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.67", "0.35"},
       "Around"],
      Around[-2.666104615926631, 0.35191939794362265`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2536022216779327`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.76", "0.33"},
       "Around"],
      Around[-2.7627217465836353`, 0.33022470143907146`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29490802248883013`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.87", "0.32"},
       "Around"],
      Around[-2.8740183095344505`, 0.31761013309149894`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3423851659881858`", ",", 
     InterpretationBox[
      TemplateBox[{"-3.00", "0.31"},
       "Around"],
      Around[-2.996429944455006, 0.30868235437034236`]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.891695668002462*^9, 3.8916957133130064`*^9, 
   3.892609945755599*^9, 3.892696818117037*^9, 3.9047156111639433`*^9, {
   3.9047156504368753`*^9, 3.9047156552465687`*^9}, {3.9047157575401344`*^9, 
   3.9047157637266335`*^9}, 3.904715798675607*^9, {3.915693191226008*^9, 
   3.915693204809351*^9}, 3.915697662638813*^9, 3.918723325054222*^9, 
   3.9187233711473155`*^9},
 CellLabel->
  "Out[968]=",ExpressionUUID->"9d4ad78e-b5af-475c-bd51-e7caf36f5dd8"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\Sample playground \
LH-ESRF-C21 NEW SAXS slopes.csv\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.891695668002462*^9, 3.8916957133130064`*^9, 
   3.892609945755599*^9, 3.892696818117037*^9, 3.9047156111639433`*^9, {
   3.9047156504368753`*^9, 3.9047156552465687`*^9}, {3.9047157575401344`*^9, 
   3.9047157637266335`*^9}, 3.904715798675607*^9, {3.915693191226008*^9, 
   3.915693204809351*^9}, 3.915697662638813*^9, 3.918723325054222*^9, 
   3.918723371445365*^9},
 CellLabel->
  "Out[970]=",ExpressionUUID->"e064bb4b-b5a4-4533-a118-a912ace76394"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\Manuscript SAXS\\\\Data & \
Code\\\\SAXS analysis\\\\LH-ESRF-C21 - number\\\\Sample playground \
LH-ESRF-C21 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.891497449054066*^9, 
   3.891497575048091*^9, 3.891498633347803*^9, 3.8914990390695996`*^9, 
   3.891499370242484*^9, {3.891499401039276*^9, 3.8914994098999367`*^9}, 
   3.8914994879861736`*^9, 3.891695668002462*^9, 3.8916957133130064`*^9, 
   3.892609945755599*^9, 3.892696818117037*^9, 3.9047156111639433`*^9, {
   3.9047156504368753`*^9, 3.9047156552465687`*^9}, {3.9047157575401344`*^9, 
   3.9047157637266335`*^9}, 3.904715798675607*^9, {3.915693191226008*^9, 
   3.915693204809351*^9}, 3.915697662638813*^9, 3.918723325054222*^9, 
   3.9187233715346613`*^9},
 CellLabel->
  "Out[971]=",ExpressionUUID->"84fd1182-3dc0-4ed0-bff9-96e8c63d0099"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2.6", ",", " ", "0.5", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.6102502709111892`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "1.2072851756630525`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.9084680942915195`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5257446817671524`"}],
  SequenceForm[
  "\[Mu]l = ", -0.6102502709111892, " \[Sigma]l = ", 1.2072851756630525`, 
   " \[Mu]r = ", 5.9084680942915195` " \[Sigma]r = ", 0.5257446817671524],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693236992298*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"17e6569c-41de-4d80-8a7d-136a7d780eda"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.6662471724237428`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7528495030836329`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.883190573253878`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5351714523790103`"}],
  SequenceForm[
  "\[Mu]l = ", -0.6662471724237428, " \[Sigma]l = ", 0.7528495030836329, 
   " \[Mu]r = ", 5.883190573253878 " \[Sigma]r = ", 0.5351714523790103],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156932523917313`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"d9540fe9-74a2-481c-90f1-81070404ab79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7547939766476692`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8603169224700923`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.755690324094212`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.564783379871365`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7547939766476692, " \[Sigma]l = ", 0.8603169224700923, 
   " \[Mu]r = ", 5.755690324094212 " \[Sigma]r = ", 0.564783379871365],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156932580255527`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"82c80342-2631-42d7-a044-c40ce2fe9435"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9018043367960868`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9644056519811995`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.25582340726312`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4122009338659925`"}],
  SequenceForm[
  "\[Mu]l = ", -0.9018043367960868, " \[Sigma]l = ", 0.9644056519811995, 
   " \[Mu]r = ", 5.25582340726312 " \[Sigma]r = ", 0.4122009338659925],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156932704460683`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"d5fde313-e2a7-4730-8522-1c7cbce648d7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9091274072311221`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9692719692121464`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"5.226482412098656`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4012636846144503`"}],
  SequenceForm[
  "\[Mu]l = ", -0.9091274072311221, " \[Sigma]l = ", 0.9692719692121464, 
   " \[Mu]r = ", 5.226482412098656 " \[Sigma]r = ", 0.4012636846144503],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156932823318553`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"b189bca1-b2e5-4974-b7ac-ea3e762355fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9232370768371824`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.949235964844187`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.995711062013804`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4997936971397946`"}],
  SequenceForm[
  "\[Mu]l = ", -0.9232370768371824, " \[Sigma]l = ", 0.949235964844187, 
   " \[Mu]r = ", 4.995711062013804 " \[Sigma]r = ", 0.4997936971397946],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693286311294*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"b7b02e0b-fdc0-4b81-95b7-05ed86ad66b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7771742490480265`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8602632853066853`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.423287099269061`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6739456652424699`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7771742490480265, " \[Sigma]l = ", 0.8602632853066853, 
   " \[Mu]r = ", 4.423287099269061 " \[Sigma]r = ", 0.6739456652424699],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156932904410725`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"01330808-7659-448b-89d5-aa401e3c8481"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7820166480156394`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.90209479565253`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.593460927979005`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6173778660461746`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7820166480156394, " \[Sigma]l = ", 0.90209479565253, 
   " \[Mu]r = ", 4.593460927979005 " \[Sigma]r = ", 0.6173778660461746],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693294458823*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"78398f52-ece0-4028-894a-de2c8e44a9b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7505542748162266`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8982806372109344`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.592025429723106`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.627849563768265`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7505542748162266, " \[Sigma]l = ", 0.8982806372109344, 
   " \[Mu]r = ", 4.592025429723106 " \[Sigma]r = ", 0.627849563768265],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693298508642*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"4fa14d11-a88d-4c59-bb44-b731582dd664"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7383486766930863`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8986359011674916`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.600311568152372`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6177968231565721`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7383486766930863, " \[Sigma]l = ", 0.8986359011674916, 
   " \[Mu]r = ", 4.600311568152372 " \[Sigma]r = ", 0.6177968231565721],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693306808828*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"9a2f1060-c4d7-46b0-99df-72324928c170"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7248489916064755`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9062617750441513`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.636959121720393`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6040081022760672`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7248489916064755, " \[Sigma]l = ", 0.9062617750441513, 
   " \[Mu]r = ", 4.636959121720393 " \[Sigma]r = ", 0.6040081022760672],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693310892889*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"ad109ca7-a71e-46b5-9db5-25381795b622"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7202903268657409`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9071327665248504`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.6408716805128325`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6029537501954315`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7202903268657409, " \[Sigma]l = ", 0.9071327665248504, 
   " \[Mu]r = ", 4.6408716805128325` " \[Sigma]r = ", 0.6029537501954315],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156933150224695`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"e18ad4ec-4be0-40e5-be02-331ff1cd360f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7184762621431687`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9076349358710822`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640803809157096`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6029877299292892`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7184762621431687, " \[Sigma]l = ", 0.9076349358710822, 
   " \[Mu]r = ", 4.640803809157096 " \[Sigma]r = ", 0.6029877299292892],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156933190915976`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"5f537226-803e-47a2-9863-29e8a4ee5012"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7170105291409825`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9081125798899058`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640418796365217`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6031204158305808`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7170105291409825, " \[Sigma]l = ", 0.9081125798899058, 
   " \[Mu]r = ", 4.640418796365217 " \[Sigma]r = ", 0.6031204158305808],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693323243822*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"5681b4f6-c3b4-481c-9438-ed8bdddbd4ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7167149277023002`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9082283189942529`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640234872735777`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6031801349951142`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7167149277023002, " \[Sigma]l = ", 0.9082283189942529, 
   " \[Mu]r = ", 4.640234872735777 " \[Sigma]r = ", 0.6031801349951142],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693327415866*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"38494209-7bbb-45f5-8f18-4c97a51a7809"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7167149992452712`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9082333124741989`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640208861123266`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6031882337133786`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7167149992452712, " \[Sigma]l = ", 0.9082333124741989, 
   " \[Mu]r = ", 4.640208861123266 " \[Sigma]r = ", 0.6031882337133786],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.915693331544256*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"19130c66-e7c3-4532-a37c-96753280feb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7167222833695`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9082312763086744`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640209449841158`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6031879538394261`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7167222833695, " \[Sigma]l = ", 0.9082312763086744, 
   " \[Mu]r = ", 4.640209449841158 " \[Sigma]r = ", 0.6031879538394261],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156933356983237`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"d01eee3b-e8cb-4b65-a7ed-ce11b5057689"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7167219983930884`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9082313690339324`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640209328652816`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.603187998660693`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7167219983930884, " \[Sigma]l = ", 0.9082313690339324, 
   " \[Mu]r = ", 4.640209328652816 " \[Sigma]r = ", 0.603187998660693],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156933483684216`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"509ceb6e-ce13-4e31-b80b-c6154f289b85"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7167220064197881`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9082313645893814`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640209252614549`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.6031880277812334`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7167220064197881, " \[Sigma]l = ", 0.9082313645893814, 
   " \[Mu]r = ", 4.640209252614549 " \[Sigma]r = ", 0.6031880277812334],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156933643840303`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"22e59806-6420-44c8-a152-52a4423e853f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.7167220098239522`"}], 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.9082313636938237`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"4.640209246048311`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.603188029910106`"}],
  SequenceForm[
  "\[Mu]l = ", -0.7167220098239522, " \[Sigma]l = ", 0.9082313636938237, 
   " \[Mu]r = ", 4.640209246048311 " \[Sigma]r = ", 0.603188029910106],
  Editable->False]], "Print",
 CellChangeTimes->{3.8909841202939205`*^9, 3.890984284896163*^9, 
  3.8909844119342785`*^9, 3.890984467442613*^9, 3.8914162524283814`*^9, 
  3.891417702948118*^9, 3.8914975996350174`*^9, 3.8914986791906385`*^9, 
  3.8914995306983347`*^9, 3.891695740149407*^9, 3.89260998047036*^9, 
  3.8926968599081573`*^9, 3.9156934043631587`*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"479f2aa8-3ba9-4b9b-9f72-c757cb58b1ff"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 82, 3, 17114157446157433921, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8914172769507356`*^9, 3.891418369238621*^9, 
  3.891497945095332*^9, 3.8914988442705393`*^9, 3.8914997395438075`*^9, 
  3.8916959085582676`*^9, 3.8926101727147646`*^9, 3.892697137110794*^9, 
  3.91569347846543*^9},
 CellLabel->
  "During evaluation of \
In[82]:=",ExpressionUUID->"02cd831a-6a7e-4849-bc4a-cab0c2760655"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "0.7167220130561338`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.9082313627756897`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "4.6402092432482105`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.6031880309643037`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "0.7376543615360548`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "0.8350874739173635`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "124.22906298284762`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "82.29534924922282`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8890831915134697`*^9, 3.889083231716405*^9, 
  3.889084522029305*^9, 3.889504478964719*^9, 3.889668839037505*^9, 
  3.8896689977438555`*^9, 3.8902046298151426`*^9, 3.8902062509864902`*^9, 
  3.8902104624878206`*^9, 3.890216989995762*^9, 3.8902173041350584`*^9, 
  3.8902179907784314`*^9, 3.8909820012674875`*^9, 3.8909824058680325`*^9, 
  3.890982955030755*^9, 3.8909840701831517`*^9, 3.8909841450834846`*^9, 
  3.8909843770126934`*^9, 3.8909844264654613`*^9, 3.890984470131813*^9, 
  3.8914172771083*^9, 3.8914183694354115`*^9, 3.891497945190528*^9, 
  3.891498844312603*^9, 3.891499739625004*^9, 3.891695908600355*^9, 
  3.8926101727459064`*^9, 3.892697137229562*^9, 3.9156934784991145`*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"34b999cb-505d-4770-afe8-e0c3925c12ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"slopeFitParams", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "1.54", ",", " ", "0.908", ",", " ", "5.00", ",", " ", "0.603"}], 
      "}"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"slopeFitParams", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "0.717", ",", " ", "0.908", ",", " ", "4.640", ",", " ", "0.603"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"slopeFitParamsD", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.717", ",", " ", "0.908", ",", " ", 
       RowBox[{"4.640", "+", 
        RowBox[{"N", "[", 
         RowBox[{"Log", "[", "2", "]"}], "]"}]}], ",", " ", "0.603"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", " ", 
             RowBox[{"10", "^", 
              RowBox[{"-", "3"}]}]}], ",", " ", 
            RowBox[{"10", "^", "0"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"-", "6"}]}], ",", " ", 
            RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Black", ",", " ", 
            RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|
             "color" -> RGBColor[
               0.6745098039215687, 0.07450980392156863, 
                0.043137254901960784`]|>,
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
         ",", " ", 
         RowBox[{
         "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
          "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent",
           " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
          "color"}]}], " ", "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
         ","}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "]"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"FitToPlot", " ", "=", " ", 
      RowBox[{
       RowBox[{"calculateIntensitiesLR", "[", 
        RowBox[{"\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}],
         "]"}], "/.", "fitSlopeLRResult"}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FitToPlot", " ", "=", " ", 
     RowBox[{"calculateIntensitiesLR", "[", 
      RowBox[{
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
       RowBox[{"slopeFitParams", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsA", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"datamergedbinned", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"5", " ", 
               RowBox[{"10", "^", 
                RowBox[{"-", "3"}]}]}], ",", " ", 
              RowBox[{"10", "^", "0"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"10", "^", 
               RowBox[{"-", "3"}]}], ",", " ", 
              RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ","}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}], ",", " ", 
            RowBox[{"10", "^", "4"}]}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "False", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks2", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"I\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"\
(\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\)\!\(\
\*StyleBox[\")\",FontSlant->\"Italic\"]\) [a.u.]\>\"", ",", " ", "None"}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Data\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}], "}"}]}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
         ",", " ", 
         RowBox[{
         "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
          "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent",
           " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
          "color"}]}], " ", "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
             RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"i", ",", 
             RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
         ","}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", "  ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotIntensityFitPlateletsB", " ", "=", " ", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"FitToPlot", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "150"}], "}"}]}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"(*", 
        RowBox[{"Optional", ":", " ", 
         RowBox[{
         "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ",
           "for", " ", "readibility"}], ":", " ", 
         RowBox[{"datamerged", "[", 
          RowBox[{"[", 
           RowBox[{"1", ";;", 
            RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Joined", "\[Rule]", 
        RowBox[{"{", "True", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Fit\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", "  ", "14"}], ",", " ", "Black"}], 
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotIntensityFitPlateletsA", ",", " ", "plotIntensityFitPlateletsB"}], 
     "]"}]}], "\n", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
         "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
      "plotIntensityFitPlatelets"}], "]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotIntensityFitPlatelets", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", " ", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitA", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", " ", "0.15"}], "]"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"5", " ", 
               RowBox[{"10", "^", 
                RowBox[{"-", "3"}]}]}], ",", " ", 
              RowBox[{"10", "^", "0"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4"}], ",", " ", "0"}], "}"}]}], "}"}]}], ","}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", " ", "0"}], "}"}]}], "}"}]}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", " ", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\"", ",", " ", 
            "None"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", 
         RowBox[{"\"\<Data\>\"", ",", " ", "\"\<Fit\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", "False"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotMarkers", "->", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotPlateletsFitB", " ", "=", " ", 
     RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
           RowBox[{"slopeFitParams", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "]"}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "->", 
        RowBox[{"{", "\"\<Fit\>\"", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"LabelStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
         "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "->", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Black", ",", " ", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.006", "]"}], ",", " ", "Automatic"}],
            "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|
             "color" -> RGBColor[
               0.6745098039215687, 0.07450980392156863, 
                0.043137254901960784`]|>,
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}],
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Joined", "->", 
        RowBox[{"{", "True", "}"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}],
    "\n", 
   RowBox[{"(*", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"FileNameJoin", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
         "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
      "plotPlateletsFit"}], "]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotPlateletsFit", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"plotPlateletsFitA", ",", "plotPlateletsFitB"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"plotPlateletsFit", ",", " ", 
       RowBox[{"ImageSize", " ", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"8", "cm"}], ",", " ", 
          RowBox[{"5.5", " ", "cm"}]}], "}"}]}]}], "]"}]}], "]"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"plot3Dprobability", " ", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"l", ",", "r", ",", 
               RowBox[{
                RowBox[{"probfunc", "[", 
                 RowBox[{
                 "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
                  ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"r", ",", "radii"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ScalingFunctions", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"Ticks", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
            RowBox[{"PowerTicks", "[", "True", "]"}], ",", "Automatic"}], 
           "}"}]}], ",", " ", "\[IndentingNewLine]", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\"", ",", 
            "\"\<Probability\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontSize", " ", "->", " ", "12"}], ",", " ", "Black"}], 
           "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"LabelStyle", "\[Rule]", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}],
              "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
           RowBox[{"ColorFunction", "->", 
            RowBox[{"(", 
             RowBox[{"ColorData", "[", "9", "]"}], ")"}]}], ","}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"PlotStyle", "->", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"BoxStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
        "]"}], "\[IndentingNewLine]", 
       RowBox[{"Export", "[", 
        RowBox[{
         RowBox[{"FileNameJoin", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
            "\"\<PlateletsFit3Dprobability.pdf\>\""}], "}"}], "]"}], ",", " ",
          "plot3Dprobability"}], "]"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "plot2Ddensity"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"ListDensityPlot", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"l", ",", "r", ",", 
               RowBox[{
                RowBox[{"probfunc", "[", 
                 RowBox[{
                 "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
                  ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"r", ",", "radii"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ScalingFunctions", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\""}], 
           "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameTicks", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
              RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
              RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
           "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ColorFunction", "->", "\"\<SunsetColors\>\""}], ",", " ", 
         RowBox[{"(*", 
          RowBox[{"\"\<CherryTones\>\"", ",", " ", 
           RowBox[{"\"\<SunsetColors\>\"", " ", 
            RowBox[{"(", 
             RowBox[{"one", " ", "directionally", " ", 
              RowBox[{"continuous", "/", "best"}]}], ")"}]}], ",", " ", 
           "\"\<LightTemperatureMap\>\"", ",", " ", 
           "\"\<ThermometerColors\>\""}], "*)"}], "\[IndentingNewLine]", 
         RowBox[{"PlotLegends", "->", " ", "Automatic"}], ",", " ", 
         RowBox[{"(*", " ", 
          RowBox[{"PlotLegends", "->", " ", 
           RowBox[{"BarLegend", "[", "\"\<SunsetColors\>\"", "]"}]}], " ", 
          "*)"}], "\[IndentingNewLine]", 
         RowBox[{"AspectRatio", "->", "Automatic"}]}], "\[IndentingNewLine]", 
        "]"}], "\[IndentingNewLine]", 
       RowBox[{"Export", "[", 
        RowBox[{
         RowBox[{"FileNameJoin", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
            "\"\<PlateletsFit2Ddensity.pdf\>\""}], "}"}], "]"}], ",", 
         "plot2Ddensity"}], "]"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{"LogNormalDistribution", "[", 
               RowBox[{
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "lengths"}], 
             "]"}]}]}], "}"}], "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{"LogNormalDistribution", "[", 
               RowBox[{
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
                RowBox[{"slopeFitParams", "[", 
                 RowBox[{"[", "4", "]"}], "]"}]}], "]"}], ",", "radii"}], 
             "]"}]}]}], "}"}], "\[Transpose]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size (nm)\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{"\"\<Thickness\>\"", ",", " ", "\"\<Radius\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletDistributions"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.90471589691509*^9, 3.904715924890894*^9}, {
   3.9047159645122304`*^9, 3.904716071450942*^9}, {3.9047161356598797`*^9, 
   3.904716135830696*^9}, {3.9047170822482233`*^9, 3.9047170844543686`*^9}, {
   3.9047183892326937`*^9, 3.904718392838284*^9}, {3.905853082168128*^9, 
   3.9058531236428075`*^9}, {3.9058532862865133`*^9, 3.905853307741397*^9}, {
   3.905860802235531*^9, 3.9058608700732336`*^9}, {3.9058613182835116`*^9, 
   3.905861322763001*^9}, {3.9058615629328394`*^9, 3.905861577024722*^9}, {
   3.9059168041875443`*^9, 3.9059168223476696`*^9}, {3.905916892999075*^9, 
   3.9059169198573914`*^9}, {3.9059170455392017`*^9, 
   3.9059170539239073`*^9}, {3.9059172181792154`*^9, 3.9059172202174587`*^9}, 
   3.9156935800802135`*^9, {3.9156936780825267`*^9, 3.915693763079025*^9}, {
   3.917508918699183*^9, 3.9175089469072795`*^9}, {3.917508983056389*^9, 
   3.91750900730221*^9}, {3.91750914873008*^9, 3.917509186495568*^9}, {
   3.9175092602750225`*^9, 3.917509340121543*^9}, {3.917512869682305*^9, 
   3.9175128723419914`*^9}, 3.9175134302907953`*^9, {3.9175135678098097`*^9, 
   3.917513569112973*^9}, {3.9187234319957914`*^9, 3.9187234328830414`*^9}},
 CellLabel->
  "In[987]:=",ExpressionUUID->"43a45305-6bb5-4c1f-b564-579d9a2a824f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.256921585253977, 
           4.174065704710909}, {-5.256921585253977, 4.189835529220337}}], 
          
          LineBox[{{-5.256921585253977, 
           4.189835529220337}, {-5.256921585253977, 4.205360522318066}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.2005387488032095`, 
           4.073259742757601}, {-5.2005387488032095`, 4.118587632818974}}], 
          
          LineBox[{{-5.2005387488032095`, 
           4.118587632818974}, {-5.2005387488032095`, 4.16194969034683}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.147166472619123, 
           4.060316135610796}, {-5.147166472619123, 4.089782626107377}}], 
          
          LineBox[{{-5.147166472619123, 
           4.089782626107377}, {-5.147166472619123, 4.118405637625673}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.09649951504208, 4.003106248180086}, {-5.09649951504208,
            4.01611303271202}}], 
          
          LineBox[{{-5.09649951504208, 4.01611303271202}, {-5.09649951504208, 
           4.028952810694088}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.048276729473299, 
           3.9389358153149536`}, {-5.048276729473299, 3.955597647650569}}], 
          
          LineBox[{{-5.048276729473299, 
           3.955597647650569}, {-5.048276729473299, 
           3.9719864070116766`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-5.002273086667765, 
           3.8914024800279385`}, {-5.002273086667765, 3.903310392808608}}], 
          
          LineBox[{{-5.002273086667765, 
           3.903310392808608}, {-5.002273086667765, 3.915078174238025}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.94768844245325, 
           3.8139079894512866`}, {-4.94768844245325, 3.834967815887749}}], 
          
          LineBox[{{-4.94768844245325, 3.834967815887749}, {-4.94768844245325,
            3.855593258362314}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.895750762859643, 
           3.7724277923240597`}, {-4.895750762859643, 3.788495548063706}}], 
          
          LineBox[{{-4.895750762859643, 
           3.788495548063706}, {-4.895750762859643, 
           3.8043092083916625`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.846540574896795, 
           3.6680318725929815`}, {-4.846540574896795, 3.6971948892513216`}}], 
          
          LineBox[{{-4.846540574896795, 
           3.6971948892513216`}, {-4.846540574896795, 
           3.7255314688563543`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.7904256789098545`, 
           3.5807972114376416`}, {-4.7904256789098545`, 3.595170940641284}}], 
          
          LineBox[{{-4.7904256789098545`, 
           3.595170940641284}, {-4.7904256789098545`, 
           3.6093409899365225`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.02], 
          Thickness[0.01]], {}, {
          
          LineBox[{{-4.745892143749627, 
           3.5305408348680896`}, {-4.745892143749627, 3.53272761870269}}], 
          
          LineBox[{{-4.745892143749627, 
           3.53272761870269}, {-4.745892143749627, 3.5349096309462915`}}]}}, {
        Antialiasing -> False, 
         Directive[
          RGBColor[
     